/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.controllers.SlotPackController;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class SlotLockJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(SlotLockJsonService.class);
    private final SlotService slotService;
    private final SlotPackController slotPackController;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "LockSlot";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            Map request = (Map)content;
            String slotId = request.get("slotId").toString();
            String type = request.get("type").toString();
            SlotInfo slotInfo = this.slotService.getSlotInfo(slotId);
            if (slotInfo != null) {
                slotInfo.setSlotType("1");
                if (type.equals("packet")) {
                    this.slotPackController.onSlotPackMessage(slotInfo);
                } else {
                    slotInfo.lock();
                }
            }
        }
        catch (Exception e) {
            log.error("Lock Slot Json Service Error " + e.getMessage());
        }
    }

    public SlotLockJsonService(SlotService slotService, SlotPackController slotPackController) {
        this.slotService = slotService;
        this.slotPackController = slotPackController;
    }
}

