/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.ScreenService;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class RenewAllBoxInfos
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(RenewAllBoxInfos.class);
    private final SlotService slotService;
    private final ScreenService screenService;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "RenewAllBoxInfo";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            for (SlotInfo slotInfo : this.slotService.getSlotInfoList()) {
                slotInfo.resetBoxInfo();
                slotInfo.alloc();
                this.screenService.sendInfoToSlotScreen(slotInfo.getSlotId());
            }
            this.slotService.renewSlotInfo();
        }
        catch (Exception e) {
            log.error("Renew All Box Info Json Service Error : exception info : " + e.getMessage());
        }
    }

    public RenewAllBoxInfos(SlotService slotService, ScreenService screenService) {
        this.slotService = slotService;
        this.screenService = screenService;
    }
}

