/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class QuerySlotJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(QuerySlotJsonService.class);
    private final SlotService slotService;

    public String getName() {
        return "InfoSlot";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put(routeKey, this.getName());
        try {
            SlotInfo info;
            Map request = (Map)content;
            String slotId = request.get("slotId").toString();
            responseMap.put("slotId", slotId);
            responseMap.put("flag", false);
            responseMap.put("count", this.slotService.getSlotInfoCount());
            if (!StrUtil.isBlank((CharSequence)slotId) && (info = this.slotService.getSlotInfo(slotId)) != null) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", info.getSlotId());
                item.put("name", info.getSlotName());
                item.put("lock", info.getLockStatus());
                item.put("current", info.getCurrentMailCount());
                item.put("total", info.getTotalMailCount());
                item.put("isUpload", info.getSlotWhetherUpload());
                item.put("isPacking", info.getIsPacking().get());
                item.put("duration", info.getBoxInfo().getDuration());
                item.put("boxCode", info.getBoxInfo().getBoxCode());
                item.put("uploadCount", info.getBoxInfo().getMails().size());
                item.put("uploadFlag", info.getBoxInfo().getUploadFlag());
                responseMap.put("data", item);
                responseMap.put("flag", true);
            }
        }
        catch (Exception e) {
            log.error("Info Slot Json Service Error " + e.getMessage());
        }
        finally {
            this.renderJson(channel, responseMap);
        }
    }

    public QuerySlotJsonService(SlotService slotService) {
        this.slotService = slotService;
    }
}

