/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.SortInfoService;
import com.simba.services.beans.SortInfo;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class QueryCarJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(QueryCarJsonService.class);
    private final SortInfoService sortInfoService;

    public String getName() {
        return "InfoCar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put(routeKey, this.getName());
        try {
            SortInfo info;
            Map request = (Map)content;
            String carId = request.get("carId").toString();
            responseMap.put("carId", carId);
            responseMap.put("flag", false);
            responseMap.put("count", this.sortInfoService.getSortInfos().size());
            if (!StrUtil.isBlank((CharSequence)carId) && (info = this.sortInfoService.getSortInfo(carId)) != null) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("barcode", info.getBarcode());
                item.put("slotsList", info.getSlotsList());
                item.put("roadSlotName", info.getRoadSlotName());
                item.put("errorCodeSvr", info.getErrorCodeSVR());
                item.put("errorCodePlc", info.getErrorCodePLC());
                item.put("droppedSlot", info.getDroppedSlotId());
                item.put("carId", info.getCarId());
                item.put("platId", info.getSorterId());
                responseMap.put("data", item);
                responseMap.put("flag", true);
            }
        }
        catch (Exception e) {
            log.error("Info Car Json Service Error " + e.getMessage());
        }
        finally {
            this.renderJson(channel, responseMap);
        }
    }

    public QueryCarJsonService(SortInfoService sortInfoService) {
        this.sortInfoService = sortInfoService;
    }
}

