/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.databases.service.ITtVersionInfoService;
import com.simba.services.SorterService;
import com.simba.services.beans.SorterInfo;
import com.simba.services.params.SortConfig;
import com.simba.wbapi.ApiClientExample;
import com.simba.wbapi.RequestEntities;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class PlatLoginService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(PlatLoginService.class);
    private final ITtVersionInfoService versionInfoService;
    private final SorterService sorterService;
    private final SortConfig sortConfig;
    private final ApiClientExample apiClientExample;
    private final RedisTemplate redisTemplate;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "Login";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put(routeKey, "AckLogin");
        try {
            Map request = (Map)content;
            responseMap.put("isUseVC", 0);
            responseMap.put("currentModel", "departure");
            String username = request.get("UserName").toString();
            String password = request.get("PassWord").toString();
            String platID = request.get("platID").toString();
            responseMap.put("username", username);
            if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
                responseMap.put("Result", "username or password can't be null");
            } else {
                RequestEntities.LogoutRequest requestParams;
                try {
                    requestParams = new RequestEntities.LogoutRequest();
                    requestParams.setEmployee_id(Integer.parseInt(username));
                    requestParams.setSort_place_id(this.sortConfig.getSortPlaceId());
                    requestParams.setIn_feed_place_id(Integer.parseInt(platID));
                    String logout = this.apiClientExample.logout(requestParams);
                    this.redisTemplate.opsForValue().set((Object)("platIdUser:" + username), null);
                }
                catch (Exception e) {
                    responseMap.put("Result", "Error");
                    log.info("logout error {}", (Object)e.getMessage());
                }
                try {
                    requestParams = new RequestEntities.LoginRequest();
                    requestParams.setEmployee_id(Integer.parseInt(username));
                    requestParams.setSort_place_id(this.sortConfig.getSortPlaceId());
                    requestParams.setIn_feed_place_id(Integer.parseInt(platID));
                    String login = this.apiClientExample.login((RequestEntities.LoginRequest)requestParams);
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode rootNode = objectMapper.readTree(login);
                    JsonNode dataNode = rootNode.get("data");
                    if (dataNode != null) {
                        String employeeFullName = dataNode.get("employee_id").asText();
                        responseMap.put("username", employeeFullName);
                    }
                    this.redisTemplate.opsForValue().set((Object)("platIdUser:" + username), (Object)platID);
                    responseMap.put("Result", "success");
                }
                catch (Exception e) {
                    responseMap.put("Result", "Error");
                }
                if (!this.sortConfig.isLoginOnSap()) {
                    responseMap.put("Result", "success");
                }
            }
            String platId = request.get("platID").toString();
            String weightRatio = request.getOrDefault("WeightPercent", "1").toString();
            SorterInfo sorterInfo = this.sorterService.getSorterById(platId);
            if (sorterInfo != null) {
                double ratio = Double.parseDouble(weightRatio);
                if (ratio < 0.0) {
                    ratio = 1.0;
                }
                sorterInfo.setWeightRatio(ratio);
            }
        }
        catch (Exception ex) {
            responseMap.put("Result", "error:" + ex.getMessage());
            log.error("Login json service error " + ex.getMessage());
        }
        this.renderJson(channel, responseMap);
    }

    public PlatLoginService(ITtVersionInfoService versionInfoService, SorterService sorterService, SortConfig sortConfig, ApiClientExample apiClientExample, RedisTemplate redisTemplate) {
        this.versionInfoService = versionInfoService;
        this.sorterService = sorterService;
        this.sortConfig = sortConfig;
        this.apiClientExample = apiClientExample;
        this.redisTemplate = redisTemplate;
    }
}

