/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.SortInfoService;
import com.simba.services.SorterService;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class MesScanService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(MesScanService.class);
    private final SortInfoService sortInfoService;
    private final SorterService sorterService;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "MesSortInfo";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, Object> sortInfoMap = new HashMap<String, Object>();
        sortInfoMap.put(routeKey, "ToMes");
        try {
            Map request = (Map)content;
            sortInfoMap.put("type", "mesSortInfo");
            String platId = request.get("platId").toString();
            sortInfoMap.put("platId", platId);
            SorterInfo sorterInfo = this.sorterService.getSorterById(platId);
            if (sorterInfo == null) {
                return;
            }
            String barcode = request.get("barcode").toString();
            SortInfo sortInfo = this.sortInfoService.createSortInfo();
            sortInfo.setBarcode(barcode);
            this.sortInfoService.requestSortInfo(sortInfo);
            sorterInfo.setCurrentSortInfo(sortInfo);
            sortInfoMap.put("barcode", sortInfo.getBarcode());
            sortInfoMap.put("result", sortInfo.getErrorCodeSVR() == 0);
            if (sortInfo.getErrorCodeSVR() == 0) {
                sortInfoMap.put("roadSlot", sortInfo.getRoadSlot());
                sortInfoMap.put("roadSlotName", sortInfo.getRoadSlotName());
            } else {
                this.sortInfoService.handleSortInfoResult(sortInfo);
            }
            sortInfoMap.put("slots", StrUtil.join((CharSequence)",", (Object[])new Object[]{sortInfo.getSlotsList()}));
            sortInfoMap.put("errorCode", sortInfo.getErrorCodeSVR());
        }
        catch (Exception ex) {
            sortInfoMap = null;
            log.error("Sort json service error " + ex.getMessage());
        }
        if (sortInfoMap != null) {
            this.renderJson(channel, sortInfoMap);
        }
    }

    public MesScanService(SortInfoService sortInfoService, SorterService sorterService) {
        this.sortInfoService = sortInfoService;
        this.sorterService = sorterService;
    }
}

