/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.controllers.PlatScanController;
import com.simba.services.SorterService;
import com.simba.services.beans.PacketScanInfo;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class MesInfoJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(MesInfoJsonService.class);
    private final SorterService sorterService;
    private final PlatScanController platScanController;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "MesInfo";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put(routeKey, "ToMes");
        try {
            Map request = (Map)content;
            String barcode = request.get("barcode").toString();
            if (StrUtil.isBlank((CharSequence)barcode)) {
                return;
            }
            String type = request.get("type").toString();
            if (StrUtil.isBlank((CharSequence)type)) {
                return;
            }
            log.debug("Recv MES Scanned Msg :" + request);
            String platId = request.get("platId").toString();
            SorterInfo plat = this.sorterService.getSorterById(platId);
            if (plat == null) {
                response.put("type", "noPlat");
                response.put("message", "\u672a\u53d1\u73b0\u6b64\u4f9b\u4ef6\u53f0\uff1a" + platId);
                this.renderJson(channel, response);
                return;
            }
            if (plat.getSorterModel() != 3) {
                response.put("type", "platModeAuto");
                response.put("message", "\u4f9b\u4ef6\u53f0" + platId + "\u81ea\u52a8\u6a21\u5f0f\u4e0d\u80fd\u8865\u7801");
                this.renderJson(channel, response);
                return;
            }
            plat.setChannel(channel);
            SortInfo sortInfo = this.sorterService.handleScannedCommand(PacketScanInfo.builder().sorterId(platId).sorterMode("3").barcode(request.getOrDefault("barcode", "").toString()).plcId("MES-SCANNED").scanMode("MES").scanType("MANUAL").complementType(request.getOrDefault("type", "").toString()).workerNo("mes").slots(request.getOrDefault("slots", "").toString().split(",")).scanTime(new Date()).build());
            this.platScanController.onPlatScanMessage(sortInfo);
            if (sortInfo == null) {
                response.put("type", "error");
                response.put("message", "\u6570\u636e\u89e3\u6790\u9519\u8bef");
                this.renderJson(channel, response);
                return;
            }
            String slots = StrUtil.join((CharSequence)",", (Object[])new Object[]{sortInfo.getSlotsList()});
            response.put("type", "success");
            response.put("slots", slots);
            response.put("message", "MES\u8865\u7801\u6210\u529f\uff1a" + platId);
            this.renderJson(channel, response);
        }
        catch (Exception ex) {
            log.error("MES Scanned Json Request Service Error: exception: " + ex.getMessage());
            response.put("type", "error");
            response.put("message", "\u5185\u90e8\u9519\u8bef\uff01");
            this.renderJson(channel, response);
        }
    }

    public MesInfoJsonService(SorterService sorterService, PlatScanController platScanController) {
        this.sorterService = sorterService;
        this.platScanController = platScanController;
    }
}

