/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.common.util.TimeUtil;
import com.simba.controllers.SlotUnlockController;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class AllSlotsUnlockJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(AllSlotsUnlockJsonService.class);
    private final SlotService slotService;
    private final SlotUnlockController slotUnlockController;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "SlotUnlock";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            for (SlotInfo slotInfo : this.slotService.getSlotInfoList()) {
                slotInfo.setSlotType("1");
                this.slotUnlockController.onSlotUnlockMessage(slotInfo);
            }
            log.debug("Slots Unlock Json Service request name : " + TimeUtil.createCurrentTimeStamp());
        }
        catch (Exception ex) {
            log.error("SlotsUnlock Get Json Service Error : " + ex.getMessage());
        }
    }

    public AllSlotsUnlockJsonService(SlotService slotService, SlotUnlockController slotUnlockController) {
        this.slotService = slotService;
        this.slotUnlockController = slotUnlockController;
    }
}

