/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.common.utils.FrameUtil;
import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.common.socket.framework.tools.ResponseTools;
import com.simba.controllers.SlotUnlockController;
import com.simba.services.ScreenService;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class SlotUnlockDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(SlotUnlockDecoder.class);
    private final SlotUnlockController slotUnlockController;
    private final SlotService slotService;
    private final ScreenService screenService;

    public boolean isLog() {
        return true;
    }

    public byte getName() {
        return 10;
    }

    public void doDecode(Channel channel, byte[] content) {
        try {
            int slotIdValue = FrameUtil.getUnsignedShortBigEndian((int)3, (byte[])content);
            String slotKey = String.valueOf(slotIdValue);
            SlotInfo slotInfo = this.slotService.getSlotInfo(slotKey);
            if (slotInfo == null) {
                log.error("[SlotPackDecoder] Slot not found! Slot ID:" + slotKey);
                return;
            }
            slotInfo.setSlotType("3");
            this.slotUnlockController.onSlotUnlockMessage(slotInfo);
            content[0] = 2;
            content[1] = 1;
            ResponseTools.commitResponse((Channel)channel, (byte[])content, (boolean)false);
            this.screenService.sendInfoToBigScreen(slotKey, 0, false);
        }
        catch (Exception ex) {
            log.error("Slot Pack Error -- Exception : " + ex.getMessage());
        }
    }

    public SlotUnlockDecoder(SlotUnlockController slotUnlockController, SlotService slotService, ScreenService screenService) {
        this.slotUnlockController = slotUnlockController;
        this.slotService = slotService;
        this.screenService = screenService;
    }
}

