/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.common.utils.FrameUtil;
import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.common.socket.framework.tools.ResponseTools;
import com.simba.controllers.PacketOffController;
import com.simba.services.ScreenService;
import com.simba.services.SlotService;
import com.simba.services.SortInfoService;
import com.simba.services.SorterService;
import com.simba.services.beans.SlotInfo;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import com.simba.services.params.MachineParams;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class PacketOffDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(PacketOffDecoder.class);
    private final SorterService sorterService;
    private final SortInfoService sortInfoService;
    private final SlotService slotService;
    private final PacketOffController packetOffController;
    private final MachineParams machineParams;
    private final ScreenService screenService;

    public boolean isLog() {
        return true;
    }

    public byte getName() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDecode(Channel channel, byte[] content) {
        this.machineParams.setLastPacketOffTime(System.currentTimeMillis());
        int position = 3;
        int carIdBinary = FrameUtil.getUnsignedShortBigEndian((int)position, (byte[])content);
        String carId = String.valueOf(carIdBinary);
        position += 2;
        int droppedSlotId = FrameUtil.getUnsignedShortBigEndian((int)(position += 3), (byte[])content);
        String droppedSlotIdKey = String.valueOf(droppedSlotId);
        byte droppedErrorCode = content[position += 2];
        ++position;
        SortInfo sortInfo = this.sortInfoService.getSortInfo(carId);
        if (sortInfo == null) {
            log.error("[PacketOffDecoder] Sort info not found! Car Id:" + carId + "barCode:" + sortInfo.getBarcode() + "sortInfo" + sortInfo);
            return;
        }
        log.info("PacketOffDecoder: sortInfo:carId:" + carId + " barcode" + sortInfo.getBarcode());
        sortInfo.setDroppedSlotId(droppedSlotId);
        sortInfo.setErrorCodePLC((int)droppedErrorCode);
        SlotInfo slotInfo = this.slotService.getSlotInfo(droppedSlotIdKey);
        log.info("PacketOffDecoder: SlotInfo1: SlotId:" + droppedSlotIdKey + " SlotName:" + (null == slotInfo ? "" : slotInfo.getSlotName()) + "carId:" + carId + "barCode:" + sortInfo.getBarcode());
        if (slotInfo != null) {
            log.info("PacketOffDecoder: SlotInfo2: SlotId:" + droppedSlotIdKey + " SlotName:" + slotInfo.getSlotName() + "carId:" + carId + "barCode:" + sortInfo.getBarcode());
            if (sortInfo.getErrorCodePLC() != 0) {
                slotInfo.setArriveCode("00000000");
                slotInfo.setSlotName("\u6536\u5bb9\u683c\u53e3");
            } else {
                slotInfo.setArriveCode(sortInfo.getRoadSlot());
                slotInfo.setSlotName(sortInfo.getRoadSlotName());
            }
            slotInfo.setTotalMailCount(slotInfo.getTotalMailCount() + 1);
            slotInfo.setCurrentMailCount(slotInfo.getCurrentMailCount() + 1);
            this.screenService.sendInfoToSlotScreen(slotInfo.getSlotId());
            sortInfo.setBoxCode(slotInfo.getBoxInfo().getBoxCode());
            sortInfo.setSlotDistrict(slotInfo.getSlotDistrict());
        }
        try {
            log.info("barCode:" + sortInfo.getBarcode() + "carId" + carId);
            byte plcIdLen = content[position];
            String plcId = new String(content, ++position, (int)plcIdLen, StandardCharsets.UTF_8);
            position += plcIdLen;
            if (!plcId.equals(sortInfo.getPlcId())) {
                log.info("barCode:" + sortInfo.getBarcode() + "carId" + carId + "!plcId.equals(sortInfo.getPlcId())" + plcId);
            }
            byte turnNumber = content[position];
            sortInfo.setPacketOffTime(new Date());
            sortInfo.setTurnNumber((int)turnNumber);
            SorterInfo sorterInfo = this.sorterService.getSorterById(sortInfo.getSorterId());
            if (sorterInfo != null) {
                log.info("PacketOffDecoder: sorterInfo:carId:" + carId + "sorterId:" + sortInfo.getSorterId() + "sorterName:" + sorterInfo.getSorterName() + "sorterId:" + sortInfo.getSorterId() + "sorterName:" + sorterInfo.getSorterName() + "sorterIbarCode:" + sortInfo.getBarcode());
                this.sortInfoService.doSetNoUploadByErrorCode(sortInfo, sorterInfo.getNoUploadError());
                log.info("onPacketOffMessage start: sorterInfo:carId:" + carId + "sorterId:" + sortInfo.getSorterId() + "sorterName:" + sorterInfo.getSorterName() + "sorterId:" + sortInfo.getSorterId() + "sorterName:" + sorterInfo.getSorterName() + "sorterIbarCode:" + sortInfo.getBarcode());
            }
            this.packetOffController.onPacketOffMessage(sortInfo);
            if (sorterInfo != null) {
                log.info("onPacketOffMessage end: sorterInfo:carId:" + carId + "sorterId:" + sortInfo.getSorterId() + "sorterName:" + sorterInfo.getSorterName() + "sorterId:" + sortInfo.getSorterId() + "sorterName:" + sorterInfo.getSorterName() + "sorterIbarCode:" + sortInfo.getBarcode());
            }
            content[0] = 2;
            content[1] = 1;
            log.info("PacketOffDecoder: content:carId" + carId + "barCode:" + sortInfo.getBarcode());
            ResponseTools.commitResponse((Channel)channel, (byte[])content, (boolean)false);
        }
        catch (Exception ex) {
            log.error("Catch an exception in PacketOffDecode:" + ex.getMessage());
        }
        finally {
            this.sortInfoService.removeSortInfo(carId);
        }
    }

    public PacketOffDecoder(SorterService sorterService, SortInfoService sortInfoService, SlotService slotService, PacketOffController packetOffController, MachineParams machineParams, ScreenService screenService) {
        this.sorterService = sorterService;
        this.sortInfoService = sortInfoService;
        this.slotService = slotService;
        this.packetOffController = packetOffController;
        this.machineParams = machineParams;
        this.screenService = screenService;
    }
}

