/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.common.util.CommonUtil;
import com.simba.controllers.MachineStatusController;
import com.simba.databases.entity.TtMachineOpsInfo;
import com.simba.databases.service.ITtBasicConfigService;
import com.simba.databases.service.ITtMachineOpsInfoService;
import com.simba.services.params.MachineParams;
import com.simba.wbapi.udp.SorterMonitorSystem;
import java.util.Date;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class MachineStatusDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(MachineStatusDecoder.class);
    private final MachineStatusController machineStatusController;
    private final ITtMachineOpsInfoService machineOpsInfoService;
    private final ITtBasicConfigService basicConfigService;
    private final MachineParams machineParams;
    private final SorterMonitorSystem sorterMonitorSystem;

    public boolean isLog() {
        return false;
    }

    public byte getName() {
        return 1;
    }

    public void doDecode(Channel channel, byte[] content) {
        try {
            Integer operation = 0;
            byte machineStatus = content[3];
            this.machineStatusController.onMachineStateMessage((int)machineStatus);
            switch (machineStatus) {
                case 1: {
                    operation = 1;
                    this.machineParams.setMachineStatus("started");
                    this.renewMachineStatus("started");
                    this.recordMachineAction(1, "started");
                    break;
                }
                case 2: {
                    operation = 2;
                    this.machineParams.setMachineStatus("stopped");
                    this.renewMachineStatus("stopped");
                    this.recordMachineAction(2, "stopped");
                    break;
                }
                case 3: {
                    operation = 2;
                    this.machineParams.setMachineStatus("pause");
                    this.renewMachineStatus("pause");
                    break;
                }
                case 4: {
                    this.machineParams.setMachineStatus("wait");
                    this.renewMachineStatus("wait");
                    break;
                }
                case 5: {
                    this.renewMachineStatus("running");
                    this.machineParams.setMachineStatus("running");
                    break;
                }
                case 6: {
                    this.machineParams.setMachineStatus("starting");
                    break;
                }
                default: {
                    this.machineParams.setMachineStatus("none");
                }
            }
            try {
                this.sorterMonitorSystem.sendStatusToSap(operation);
            }
            catch (Exception e) {
                log.error("sendBarCodeToSap error: " + e.getMessage());
            }
        }
        catch (Exception ex) {
            log.error("MachineStatus Decode Catch Exception : " + ex.getMessage());
        }
    }

    private void recordMachineAction(int opsType, String opsDesc) {
        try {
            this.machineOpsInfoService.save((Object)TtMachineOpsInfo.builder().workerNo("none").opsType(Integer.valueOf(opsType)).opsDesc(CommonUtil.doNullData((String)opsDesc, (String)"none")).opsTime(new Date()).build());
        }
        catch (Exception ex) {
            log.error("Record machine action catch exception : " + ex.getMessage());
        }
    }

    private void renewMachineStatus(String value) {
        String machineStatus = this.machineParams.getMachineStatus();
        if (machineStatus.equals("running") && value.equals("running")) {
            return;
        }
        this.basicConfigService.updateConfig("runStatus", value);
    }

    public MachineStatusDecoder(MachineStatusController machineStatusController, ITtMachineOpsInfoService machineOpsInfoService, ITtBasicConfigService basicConfigService, MachineParams machineParams, SorterMonitorSystem sorterMonitorSystem) {
        this.machineStatusController = machineStatusController;
        this.machineOpsInfoService = machineOpsInfoService;
        this.basicConfigService = basicConfigService;
        this.machineParams = machineParams;
        this.sorterMonitorSystem = sorterMonitorSystem;
    }
}

