/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.services.params.MachineParams;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class MachineErrorDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(MachineErrorDecoder.class);
    private final MachineParams machineParams;

    public boolean isLog() {
        return true;
    }

    public byte getName() {
        return 2;
    }

    public void doDecode(Channel channel, byte[] content) {
        try {
            byte machineStatus = content[3];
            switch (machineStatus) {
                case 1: {
                    this.machineParams.setMachineStatus("starting");
                    break;
                }
                case 2: {
                    this.machineParams.setMachineStatus("stopping");
                    break;
                }
                case 3: {
                    this.machineParams.setMachineStatus("stopping");
                    break;
                }
                case 4: {
                    this.machineParams.setMachineStatus("waiting");
                    break;
                }
                case 5: {
                    this.machineParams.setMachineStatus("running");
                    break;
                }
                default: {
                    this.machineParams.setMachineStatus("none");
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error("MachineStatus decode catch an exception: " + ex.getMessage());
        }
    }

    public MachineErrorDecoder(MachineParams machineParams) {
        this.machineParams = machineParams;
    }
}

