/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.net.NetTools;
import com.simba.common.socket.common.utils.FrameUtil;
import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.common.util.CommonUtil;
import java.util.HashMap;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class EchoTimeDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(EchoTimeDecoder.class);

    public boolean isLog() {
        return false;
    }

    public byte getName() {
        return 17;
    }

    public void doDecode(Channel channel, byte[] message) {
        long plcTime = FrameUtil.getLongBigEndian((int)3, (byte[])message);
        long now = System.currentTimeMillis();
        HashMap<String, Object> echoTime = new HashMap<String, Object>();
        echoTime.put("ServiceName", "EchoTime");
        echoTime.put("plcTime", plcTime);
        echoTime.put("serverTime", now);
        echoTime.put("delta", now - plcTime + "ms");
        NetTools.getPlatServer().getClients().values().forEach(client -> client.sendJsonContent(CommonUtil.getGson().toJson((Object)echoTime)));
    }
}

