/*
 * Decompiled with CFR 0.152.
 */
package com.simba.databases.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.common.util.CommonUtil;
import com.simba.databases.entity.TtSlotPackInfo;
import com.simba.databases.mapper.TtSlotPackInfoMapper;
import com.simba.databases.service.ITtSlotPackInfoService;
import com.simba.services.beans.SlotInfo;
import com.simba.services.params.SorterParams;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TtSlotPackInfoServiceImpl
extends ServiceImpl<TtSlotPackInfoMapper, TtSlotPackInfo>
implements ITtSlotPackInfoService {
    @Resource
    private SorterParams sorterParams;

    public boolean deleteRecord(Timestamp recordTime) {
        return this.remove((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().le(TtSlotPackInfo::getRecordTime, (Object)recordTime)).last("limit 10000"));
    }

    public List<TtSlotPackInfo> getNeedUploadData() {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TtSlotPackInfo::getUploadFlag, (Object)0)).lt(TtSlotPackInfo::getUploadNum, (Object)this.sorterParams.getUploadNum())).orderByAsc(TtSlotPackInfo::getId)).last("limit 100"));
    }

    public boolean saveBySlotInfo(SlotInfo slotInfo) {
        SlotInfo.BoxInfo boxInfo = slotInfo.getBoxInfo();
        return this.save((Object)TtSlotPackInfo.builder().slotId(CommonUtil.doNullData((String)slotInfo.getSlotId(), (String)"none")).boxCode(CommonUtil.doNullData((String)boxInfo.getBoxCode(), (String)"none")).boxType(CommonUtil.doNullData((String)boxInfo.getBoxType(), (String)"none")).createTime(CommonUtil.doNullData((String)boxInfo.getCreateTime(), (String)"none")).mailCount(Integer.valueOf(boxInfo.getMails().size())).uploadFlag(Integer.valueOf(-1)).uploadNum(Integer.valueOf(0)).planId(CommonUtil.doNullData((String)boxInfo.getPlanId(), (String)"none")).printFlag(Integer.valueOf(0)).syncFlag(Integer.valueOf(0)).roadSlot(CommonUtil.doNullData((String)boxInfo.getRoadSlot(), (String)"none")).recordTime(new Date()).build());
    }

    public boolean updateByBoxCode(SlotInfo.BoxInfo boxInfo) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(TtSlotPackInfo::getBoxType, (Object)boxInfo.getBoxType())).set(TtSlotPackInfo::getUploadFlag, (Object)boxInfo.getUploadFlag())).set(TtSlotPackInfo::getUploadNum, (Object)boxInfo.getUploadNum())).set(TtSlotPackInfo::getRoadSlot, (Object)boxInfo.getRoadSlot())).eq(TtSlotPackInfo::getBoxCode, (Object)boxInfo.getBoxCode()));
    }

    public boolean updateDuration(long duration, String boxCode) {
        return this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(TtSlotPackInfo::getDuration, (Object)duration)).eq(TtSlotPackInfo::getBoxCode, (Object)boxCode));
    }
}

