/*
 * Decompiled with CFR 0.152.
 */
package com.simba.databases.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.common.time.RecordTime;
import com.simba.common.util.CommonUtil;
import com.simba.databases.entity.TtPacketOffInfo;
import com.simba.databases.mapper.TtPacketOffInfoMapper;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.SortConfig;
import com.simba.services.params.SorterParams;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TtPacketOffInfoServiceImpl
extends ServiceImpl<TtPacketOffInfoMapper, TtPacketOffInfo>
implements ITtPacketOffInfoService {
    @Resource
    private SorterParams sorterParams;
    @Resource
    private SortConfig sortConfig;

    public boolean deleteRecord(Timestamp recordTime) {
        return this.remove((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().le(TtPacketOffInfo::getRecordTime, (Object)recordTime)).last("limit 10000"));
    }

    @RecordTime
    public boolean saveBySortInfo(SortInfo sortInfo) {
        return this.save((Object)TtPacketOffInfo.builder().barcode(CommonUtil.doNullData((String)sortInfo.getBarcode(), (String)"none")).barcodeList(StrUtil.join((CharSequence)",", (Object[])new Object[]{sortInfo.getBarcodeList()})).sorterId(CommonUtil.doNullData((String)sortInfo.getSorterId(), (String)"none")).carId(Integer.valueOf(Integer.parseInt(sortInfo.getCarId()))).plcId(CommonUtil.doNullData((String)sortInfo.getPlcId(), (String)"none")).serverSlots(CommonUtil.doNullData((String)StrUtil.join((CharSequence)",", (Object[])new Object[]{sortInfo.getSlotsList()}), (String)"none")).droppedSlot(Integer.valueOf(sortInfo.getDroppedSlotId())).sortingId(CommonUtil.doNullData((String)this.buildSortingId(sortInfo.getSortingId()), (String)"none")).boxCode(CommonUtil.doNullData((String)sortInfo.getBoxCode(), (String)"none")).turnNumber(Integer.valueOf(sortInfo.getTurnNumber())).obrNo(Integer.valueOf(sortInfo.getObr())).errorCodeSvr(Integer.valueOf(sortInfo.getErrorCodeSVR())).errorCodePlc(Integer.valueOf(sortInfo.getErrorCodePLC())).packetScanTime(sortInfo.getPacketScanTime()).packetOnTime(sortInfo.getPacketOnTime()).packetOffTime(sortInfo.getPacketOffTime()).uploadFlag(Integer.valueOf(sortInfo.getUploadFlag())).uploadNum(Integer.valueOf(sortInfo.getUploadNum())).slotDistrict(Integer.valueOf(sortInfo.getSlotDistrict())).roadSlot(CommonUtil.doNullData((String)sortInfo.getRoadSlot(), (String)"none")).roadSlotName(CommonUtil.doNullData((String)sortInfo.getRoadSlotName(), (String)"none")).syncFlag(Integer.valueOf(sortInfo.getIsSj())).weight(CommonUtil.doNullData((String)(CommonUtil.isNumberNull((String)sortInfo.getWeight()) ? sortInfo.getChargeWeight() : sortInfo.getWeight()), (String)"0")).length(CommonUtil.doNullData((String)sortInfo.getLength(), (String)"0")).width(CommonUtil.doNullData((String)sortInfo.getWidth(), (String)"0")).height(CommonUtil.doNullData((String)sortInfo.getHeight(), (String)"0")).volume(CommonUtil.doNullData((String)sortInfo.getVolume(), (String)"0")).serverSlotsType(CommonUtil.doNullData((String)sortInfo.getServerSlotsType(), (String)"none")).workerNo(CommonUtil.doNullData((String)sortInfo.getWorkerNo(), (String)"none")).recordTime(new Date()).area(CommonUtil.doNullData((String)this.sortConfig.getArea(), (String)"0")).imgUuid(sortInfo.getImgUuid()).build());
    }

    public List<TtPacketOffInfo> listPacketByBoxCode(String boxCode) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(TtPacketOffInfo::getUploadFlag, (Object)-2)).eq(TtPacketOffInfo::getBoxCode, (Object)boxCode));
    }

    public long getPacketCount(String beginTime, String endTime) {
        return this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().gt(TtPacketOffInfo::getRecordTime, (Object)beginTime)).le(TtPacketOffInfo::getRecordTime, (Object)endTime));
    }

    public List<TtPacketOffInfo> listPacketByBarcode(String barcode) {
        return this.list((Wrapper)Wrappers.lambdaQuery().eq(TtPacketOffInfo::getBarcode, (Object)barcode));
    }

    public boolean updateBarcodeInfoExpired(String barcode) {
        return this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(TtPacketOffInfo::getExpiredFlag, (Object)1)).eq(TtPacketOffInfo::getBarcode, (Object)barcode));
    }

    public boolean updateUploadFlagById(int flag, int num, String id) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(TtPacketOffInfo::getUploadFlag, (Object)flag)).set(TtPacketOffInfo::getUploadNum, (Object)num)).eq(TtPacketOffInfo::getId, (Object)id));
    }

    public List<TtPacketOffInfo> listPacketByNoUpload() {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TtPacketOffInfo::getUploadFlag, (Object)0)).lt(TtPacketOffInfo::getUploadNum, (Object)this.sorterParams.getUploadNum())).orderByAsc(TtPacketOffInfo::getId)).last("limit 1000"));
    }

    public TtPacketOffInfo getLastBarcodeByPlcId(String plcId) {
        return (TtPacketOffInfo)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TtPacketOffInfo::getPlcId, (Object)plcId)).orderByDesc(TtPacketOffInfo::getRecordTime)).last("limit 1"));
    }

    public TtPacketOffInfo getLastPlcIdByBarcode(String barcode) {
        return (TtPacketOffInfo)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TtPacketOffInfo::getBarcode, (Object)barcode)).orderByDesc(TtPacketOffInfo::getRecordTime)).last("limit 1"));
    }

    private String buildSortingId(String sortingId) {
        if (StrUtil.isBlank((CharSequence)sortingId)) {
            return null;
        }
        if (sortingId.length() > 16) {
            sortingId = sortingId.substring(0, 16);
        }
        return sortingId;
    }
}

