/*
 * Decompiled with CFR 0.152.
 */
package com.simba.databases.controller;

import com.simba.common.data.FormRp;
import com.simba.common.data.ParamDTO;
import com.simba.common.util.R;
import com.simba.databases.service.ITtPacketOffInfoReportService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form"})
public class FormController {
    private static final Logger log = LoggerFactory.getLogger(FormController.class);
    private final ITtPacketOffInfoReportService packetOffInfoReportService;

    @PostMapping(value={"slot/pack"})
    public R<?> pack(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formBySlotPackCount(rp.getMaps()));
    }

    @PostMapping(value={"slot/off"})
    public R<?> off(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formBySlotCount(rp.getMaps()));
    }

    @PostMapping(value={"plat"})
    public R<?> plat(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByPlat(rp.getMaps()));
    }

    @PostMapping(value={"slot/off/line"})
    public R<?> line(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByLineSlotCount(rp.getMaps()));
    }

    @PostMapping(value={"rate/read"})
    public R<?> read(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByReadRate(rp.getMaps()));
    }

    @PostMapping(value={"sort/general"})
    public R<?> sortGeneral(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formBySortGeneral(rp.getMaps()));
    }

    @PostMapping(value={"efficiency/plat"})
    public R<?> efficiencyPlatTime(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByEfficiencyPlat(rp.getMaps()));
    }

    @PostMapping(value={"rate/general"})
    public R<?> generalRate(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByGeneralRate(rp.getMaps()));
    }

    @PostMapping(value={"max/sort"})
    public R<?> maxSortByTime(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByMaxSortTime(rp.getMaps()));
    }

    @PostMapping(value={"time/rate/read"})
    public R<?> readRateTime(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByReadRateTime(rp.getMaps()));
    }

    @PostMapping(value={"des"})
    public R<?> desCode(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByDesCode(rp.getMaps()));
    }

    @PostMapping(value={"time/error"})
    public R<?> errorCodeTime(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formByErrorCode(rp.getMaps()));
    }

    @PostMapping(value={"time/slot"})
    public R<?> slotTime(@RequestBody @Validated FormRp rp) {
        return R.ok((Object)this.packetOffInfoReportService.formBySlot(rp.getMaps()));
    }

    @PostMapping(value={"execute"})
    public R<?> execute(@RequestBody @Validated FormRp rp) {
        Map params = rp.getMaps();
        if (!params.containsKey("sql")) {
            return R.error((String)"\u65e0\u6709\u6548\u53c2\u6570");
        }
        String sql = ((ParamDTO)params.get("sql")).getValue().toString();
        List result = this.packetOffInfoReportService.execute(sql);
        if (result == null) {
            return R.error((String)"\u65e0\u6570\u636e");
        }
        return R.ok((Object)result);
    }

    public FormController(ITtPacketOffInfoReportService packetOffInfoReportService) {
        this.packetOffInfoReportService = packetOffInfoReportService;
    }
}

