/*
 * Decompiled with CFR 0.152.
 */
package com.simba.controllers;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.tools.ResponseTools;
import com.simba.databases.entity.TtLocalSortInfo;
import com.simba.databases.service.ITtLocalSortInfoService;
import com.simba.databases.service.ITtPacketOnInfoService;
import com.simba.services.BarcodeService;
import com.simba.services.SortInfoService;
import com.simba.services.SorterService;
import com.simba.services.TaskPoolService;
import com.simba.services.beans.PacketOnInfo;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import com.simba.services.params.SortConfig;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Resource;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PacketOnController {
    private static final Logger log = LoggerFactory.getLogger(PacketOnController.class);
    @Resource
    private SortInfoService sortInfoService;
    @Resource
    private BarcodeService barcodeService;
    @Resource
    private SortConfig sortConfig;
    @Resource
    private ITtPacketOnInfoService packetOnInfoService;
    @Resource
    private TaskPoolService taskPoolService;
    @Resource
    private SorterService sorterService;
    @Resource
    private ITtLocalSortInfoService localSortInfoService;

    public void onPacketOnMessage(PacketOnInfo packetOnInfo) {
        try {
            this.doPacketWeight(packetOnInfo);
            this.handlePacketOn(packetOnInfo);
            this.sendWeightToPlat(packetOnInfo);
            this.printPacketOnInfo(packetOnInfo);
        }
        catch (Exception ex) {
            log.error("Handle packet on message error -- Exception : " + ex);
        }
    }

    private void doPacketWeight(PacketOnInfo packetOnInfo) {
        try {
            if (this.sortConfig.getWeightMode() == 0) {
                return;
            }
            if (this.sortConfig.getWeightMode() == 1) {
                return;
            }
            TtLocalSortInfo localSortInfo = this.localSortInfoService.listByBarcode(packetOnInfo.getBarcode());
            if (localSortInfo == null || StrUtil.isBlank((CharSequence)localSortInfo.getWeight())) {
                return;
            }
            log.info("Reset barcode[{}] weight {}->{}", new Object[]{packetOnInfo.getBarcode(), packetOnInfo.getWeight(), localSortInfo.getWeight()});
            packetOnInfo.setWeight(localSortInfo.getWeight());
        }
        catch (Exception ex) {
            log.error("Get barcode[{}] weight error: {}", (Object)packetOnInfo.getBarcode(), (Object)ex.getMessage());
        }
    }

    private void handlePacketOn(PacketOnInfo packetOnInfo) {
        if (packetOnInfo.getSorterMode().equals("3")) {
            SorterInfo sorterInfo = this.sorterService.getSorterById(packetOnInfo.getSorterId());
            if (sorterInfo == null) {
                return;
            }
            this.sorterService.handlePacketOnCommand(packetOnInfo);
            this.savePacketOnInfo(packetOnInfo);
        } else {
            this.sorterService.addPacketOnInfo(packetOnInfo.getCarId(), packetOnInfo);
        }
    }

    private void savePacketOnInfo(PacketOnInfo packetOnInfo) {
        this.taskPoolService.execute(() -> this.packetOnInfoService.saveBySortInfo(packetOnInfo));
    }

    private void sendWeightToPlat(PacketOnInfo packetOnInfo) {
        String platId = packetOnInfo.getSorterId();
        String weight = packetOnInfo.getWeight();
        String barcode = packetOnInfo.getBarcode();
        SorterInfo plat = this.sorterService.getSorterById(platId);
        if (plat == null) {
            log.error("Unknown plat: " + platId);
            return;
        }
        try {
            DecimalFormat df = new DecimalFormat("#0.00");
            weight = df.format(Double.parseDouble(weight) / 100.0);
        }
        catch (Exception e) {
            log.error("Found an exception when format weight: " + e.getMessage());
        }
        HashMap<String, Object> sortInfoMap = new HashMap<String, Object>();
        sortInfoMap.put("ServiceName", "GetWeight");
        sortInfoMap.put("platId", platId);
        sortInfoMap.put("barcode", barcode);
        sortInfoMap.put("weight", weight);
        sortInfoMap.put("layer", 1);
        ResponseTools.commitResponse((Channel)plat.getChannel(), sortInfoMap, (boolean)false);
    }

    private void requestSortInfo(SortInfo sortInfo) {
        try {
            String barcode = sortInfo.getBarcode().toLowerCase();
            if (barcode.equals("noread")) {
                sortInfo.setErrorCodeSVR(3);
            } else if (!this.barcodeService.checkBarcodeListValid(sortInfo)) {
                sortInfo.setErrorCodeSVR(4);
            } else if (!this.barcodeService.checkBarcodeValid(barcode)) {
                sortInfo.setErrorCodeSVR(7);
            } else {
                this.sortInfoService.requestSortInfo(sortInfo);
            }
            this.sortInfoService.handleSortInfoResult(sortInfo);
            if (this.sortConfig.isSlotSort()) {
                Collections.sort(sortInfo.getSlotsList());
            }
        }
        catch (Exception ex) {
            log.error("Request Sort Info Error -- Exception : " + ex);
        }
    }

    private void printPacketOnInfo(PacketOnInfo packetOnInfo) {
        try {
            StringBuilder info = new StringBuilder();
            info.append("[Key:PacketOnDecoder],");
            info.append("[SorterID:").append(packetOnInfo.getSorterId()).append("],");
            info.append("[Barcode:").append(packetOnInfo.getBarcode()).append("],");
            info.append("[PlcID:").append(packetOnInfo.getPlcId()).append("],");
            info.append("[Weight:").append(packetOnInfo.getWeight()).append("]");
            log.debug(info.toString());
        }
        catch (Exception ex) {
            log.error("[PacketOnDecoder.recordSortResult] Error:" + ex.getMessage());
        }
    }
}

