/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.util;

import com.simba.common.util.TimeUtil;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConUtil {
    private static final Logger log = LoggerFactory.getLogger(ConUtil.class);
    public static String PAGE_NUM = "page";
    public static String PAGE_TOTAL = "total";
    public static String PAGE_DATA_LIST = "list";
    public static String PAGE_DATA_ID = "id";
    public static String PAGE_SIZE = "pageSize";

    public static String longToDate(long lo) {
        Date date = new Date(lo);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sd.format(date);
    }

    public static String createItemUId() {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        uuid = uuid.substring(0, 13);
        return uuid;
    }

    public static Integer changeStringToInt(String requireQty) {
        return (int)Math.ceil(Double.parseDouble(requireQty));
    }

    public static String createSortUId(int platId) {
        String[] strPlats = String.valueOf(platId).split("");
        String strPlat = strPlats[strPlats.length - 1];
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        uuid = uuid.substring(7, 12);
        Long uuidTime = System.currentTimeMillis();
        String strUid = uuidTime.toString().substring(6, 13);
        return strPlat + uuid + strUid;
    }

    public static String getIpAddressFromChannel(Channel channel) {
        String addressOrg = channel.getRemoteAddress().toString();
        String sunAddress = addressOrg.substring(1);
        String[] splitAddress = sunAddress.trim().split(":");
        return splitAddress[0];
    }

    public static String addSpace(int count, Integer num) {
        return String.format("%0" + count + "d", num);
    }

    public static boolean isEqual(String param, String s) {
        return param.trim().equals(s);
    }

    public static List<Map> pageBySubList(List<Map> list, int pagesize, int currentPage) {
        int totalcount = list.size();
        int pagecount = 0;
        int m = totalcount % pagesize;
        pagecount = m > 0 ? totalcount / pagesize + 1 : totalcount / pagesize;
        List<Map> subList = m == 0 ? list.subList((currentPage - 1) * pagesize, pagesize * currentPage) : (currentPage == pagecount ? list.subList((currentPage - 1) * pagesize, totalcount) : list.subList((currentPage - 1) * pagesize, pagesize * currentPage));
        return subList;
    }

    public static String formatDuring(long mss) {
        if (mss == 0L) {
            return "0 \u5929 0 \u65f6 0 \u5206 0 \u79d2 ";
        }
        long days = mss / 86400000L;
        long hours = mss % 86400000L / 3600000L;
        long minutes = mss % 3600000L / 60000L;
        long seconds = mss % 60000L / 1000L;
        return days + " \u5929 " + hours + " \u65f6 " + minutes + " \u5206 " + seconds + " \u79d2 ";
    }

    public static String getLastDays(int n) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, -n);
            String time = df.format(calendar.getTime());
            return time;
        }
        catch (Exception ex) {
            log.error("[getLastDays] catch error :" + ex.getMessage());
            return null;
        }
    }

    public static long subtractTime(String date) {
        long time = 0L;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = TimeUtil.createCurrentTimeStampLong() - sdf.parse(date).getTime();
            return time;
        }
        catch (Exception e) {
            e.printStackTrace();
            return time;
        }
    }

    public static long strTimeToLong(String date) {
        long time = 0L;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = sdf.parse(date).getTime();
            return time;
        }
        catch (Exception e) {
            e.printStackTrace();
            return time;
        }
    }

    public static boolean isOddNumber(int i) {
        return (i & 1) == 1;
    }

    public static byte[] hexStrToByteArray(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return new byte[0];
        }
        byte[] byteArray = new byte[str.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            String subStr = str.substring(2 * i, 2 * i + 2);
            byteArray[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return byteArray;
    }

    public static String strGetBytesHex(String s, String charsetName) {
        StringBuilder rt = new StringBuilder();
        if (null == s) {
            return null;
        }
        try {
            byte[] arr = null != charsetName && charsetName.length() > 0 ? s.getBytes(charsetName) : s.getBytes();
            if (null == arr) {
                return null;
            }
            for (int i = 0; i < arr.length; ++i) {
                String s2 = Integer.toHexString(arr[i] & 0xFF).toUpperCase();
                if (s2.length() < 2) {
                    s2 = "0" + s2;
                }
                rt.append(s2);
            }
            return rt.toString();
        }
        catch (UnsupportedEncodingException e) {
            log.error("strGetBytesHex is error : string :" + s + ", charsetName :" + charsetName + " , ex :" + e.getMessage());
            return null;
        }
    }

    public static String getCRC(byte[] bytes) {
        int CRC = 65535;
        int POLYNOMIAL = 40961;
        for (int i = 0; i < bytes.length; ++i) {
            CRC ^= bytes[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((CRC & 1) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                    continue;
                }
                CRC >>= 1;
            }
        }
        String result = Integer.toHexString(CRC).toUpperCase();
        if (result.length() != 4) {
            StringBuffer sb = new StringBuffer("0000");
            result = sb.replace(4 - result.length(), 4, result).toString();
        }
        return result.substring(2, 4) + result.substring(0, 2);
    }
}

