/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.time;

import com.simba.common.time.RecordTime;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SysTimeAspect {
    private static final Logger log = LoggerFactory.getLogger(SysTimeAspect.class);

    @Pointcut(value="@annotation(com.simba.common.time.RecordTime)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long endTime = System.currentTimeMillis();
        long diff = endTime - beginTime;
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        RecordTime recordTime = method.getAnnotation(RecordTime.class);
        if (recordTime != null && diff > 3000L) {
            log.info("[" + signature.getName() + "] \u65b9\u6cd5\u6267\u884c\uff01 \u8017\u65f6\uff1a" + diff + " ms");
        }
        return result;
    }
}

