/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.net;

import com.simba.common.net.manager.FrameByteServiceManager;
import com.simba.common.socket.common.net.base.NetModule;
import com.simba.common.socket.common.utils.SpringBeanUtils;
import com.simba.common.socket.framework.bean.ServerBean;
import com.simba.common.socket.framework.config.NetConfigProperties;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="net", value={"enable"}, havingValue="true")
@ConditionalOnBean(value={SpringBeanUtils.class})
public class SocketConfig {
    private final NetConfigProperties netConfigProperties;
    private final NetModule netModule;

    private ServerBean getServerBean(String key) {
        List list = this.netConfigProperties.getServers();
        if (list != null) {
            for (ServerBean bean : list) {
                if (!bean.getKey().equals(key)) continue;
                return bean;
            }
        }
        return null;
    }

    @Bean
    public FrameByteServiceManager frameByteServiceManager() {
        int corePoolSize = 5;
        int maxPoolSize = 5;
        int commandPoint = 2;
        boolean printReceiveLog = false;
        ServerBean serverBean = this.getServerBean("frame");
        if (serverBean != null) {
            corePoolSize = serverBean.getHandleCorePoolSize();
            maxPoolSize = serverBean.getHandleMaxPoolSize();
            commandPoint = serverBean.getCommandPoint();
            printReceiveLog = serverBean.isPrintReceiveLog();
        }
        FrameByteServiceManager frameByteServiceManager = new FrameByteServiceManager(corePoolSize, maxPoolSize);
        frameByteServiceManager.setCommandPoint(commandPoint);
        frameByteServiceManager.setPrintReceivedLog(printReceiveLog);
        return frameByteServiceManager;
    }

    public void test() {
    }

    public SocketConfig(NetConfigProperties netConfigProperties, NetModule netModule) {
        this.netConfigProperties = netConfigProperties;
        this.netModule = netModule;
    }
}

