/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.data;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.simba.common.data.DateDTO;
import com.simba.common.data.ParamDTO;
import com.simba.common.data.TablePageRp;
import java.util.Map;

public class DataUtil {
    public static <T> QueryWrapper<T> getQueryWrapperFromParams(Map<String, ParamDTO> maps) {
        QueryWrapper wrapper = new QueryWrapper();
        Gson gson = new GsonBuilder().serializeNulls().create();
        if (maps != null) {
            maps.forEach((key, paramDTO) -> {
                if (paramDTO.getValue() != null) {
                    switch (paramDTO.getType()) {
                        case 0: {
                            if (!StrUtil.isNotBlank((CharSequence)paramDTO.getValue().toString())) break;
                            String value = paramDTO.getValue().toString();
                            if (value.contains(",")) {
                                wrapper.in((Object)StrUtil.toUnderlineCase((CharSequence)key), (Object[])value.split(","));
                                break;
                            }
                            if (value.matches("\\s+")) {
                                wrapper.in((Object)StrUtil.toUnderlineCase((CharSequence)key), (Object[])value.split("\\s+"));
                                break;
                            }
                            if (value.contains("*")) {
                                if (value.startsWith("*") && value.endsWith("*")) {
                                    wrapper.like((Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)value.substring(1, value.length() - 1));
                                    break;
                                }
                                if (value.startsWith("*")) {
                                    wrapper.likeLeft((Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)value.substring(1));
                                    break;
                                }
                                if (value.endsWith("*")) {
                                    wrapper.likeRight((Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)value.substring(0, value.length() - 1));
                                    break;
                                }
                                wrapper.like((Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)value);
                                break;
                            }
                            wrapper.eq((Object)StrUtil.toUnderlineCase((CharSequence)key), paramDTO.getValue());
                            break;
                        }
                        case 1: 
                        case 3: {
                            wrapper.in((Object)StrUtil.toUnderlineCase((CharSequence)key), new Object[]{paramDTO.getValue()});
                            break;
                        }
                        case 2: {
                            DateDTO dateBean = (DateDTO)gson.fromJson(gson.toJson(paramDTO.getValue()), new /* Unavailable Anonymous Inner Class!! */.getType());
                            if (dateBean == null) break;
                            ((QueryWrapper)wrapper.ge(dateBean.getBeginDate() != null, (Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)dateBean.getBeginDate())).lt(dateBean.getEndDate() != null, (Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)dateBean.getEndDate());
                            break;
                        }
                    }
                }
            });
        }
        return wrapper;
    }

    public static <T> IPage<T> pageParamConvert(TablePageRp param) {
        return new Page((long)param.getPageNo(), (long)param.getPageSize());
    }
}

