/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.util.Hashing;
import redis.clients.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardedJedisPool
extends Pool<ShardedJedis> {
    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards) {
        this(poolConfig, shards, Hashing.MURMUR_HASH);
    }

    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards, Hashing algo) {
        this(poolConfig, shards, algo, null);
    }

    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards, Pattern keyTagPattern) {
        this(poolConfig, shards, Hashing.MURMUR_HASH, keyTagPattern);
    }

    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(poolConfig, new ShardedJedisFactory(shards, algo, keyTagPattern));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShardedJedisFactory
    extends BasePoolableObjectFactory {
        private List<JedisShardInfo> shards;
        private Hashing algo;
        private Pattern keyTagPattern;

        public ShardedJedisFactory(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
            this.shards = shards;
            this.algo = algo;
            this.keyTagPattern = keyTagPattern;
        }

        @Override
        public Object makeObject() throws Exception {
            ShardedJedis jedis = new ShardedJedis(this.shards, this.algo, this.keyTagPattern);
            return jedis;
        }

        @Override
        public void destroyObject(Object obj) throws Exception {
            if (obj != null && obj instanceof ShardedJedis) {
                ShardedJedis shardedJedis = (ShardedJedis)obj;
                for (Jedis jedis : shardedJedis.getAllShards()) {
                    try {
                        try {
                            jedis.quit();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        jedis.disconnect();
                    }
                    catch (Exception e) {}
                }
            }
        }

        @Override
        public boolean validateObject(Object obj) {
            try {
                ShardedJedis jedis = (ShardedJedis)obj;
                for (Jedis shard : jedis.getAllShards()) {
                    if (shard.ping().equals("PONG")) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

