/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private List _listeners = new LinkedList();

    public static void send(Message message) throws MessagingException {
        Transport.send(message, message.getAllRecipients());
    }

    public static void send(Message message, Address[] addresses) throws MessagingException {
        Transport transport = null;
        transport.sendMessage(message, addresses);
    }

    public Transport(Session session, URLName name) {
        super(session, name);
    }

    public void addTransportListener(TransportListener listener) {
        this._listeners.add(listener);
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message message) {
        TransportEvent event = new TransportEvent(this, type, validSent, validUnsent, invalid, message);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            TransportListener listener = (TransportListener)it.next();
            event.dispatch(listener);
        }
    }

    public void removeTransportListener(TransportListener listener) {
        this._listeners.remove(listener);
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;
}

