/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network.tools;

import com.simba.common.utils.StringUtil;
import com.simba.views.main.InternalFrame;
import com.simba.views.main.manager.ApplicationParams;
import com.simba.views.network.JPanelRecvDistribute;
import com.simba.views.network.factory.UiFactory;
import com.simba.views.network.tools.InterceptorBuilderArgs;
import com.simba.views.network.tools.InterceptorTools;
import com.simba.views.network.ui.ComBoxItemBean;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.commons.collections.map.HashedMap;

public class InterceptorBuilder {
    private Map<String, JComboBox<ComBoxItemBean>> comboxs = new HashedMap();
    private Map<String, Map<String, ComBoxItemBean>> conditions = new HashedMap();
    private Map<String, JPanelRecvDistribute> distributes = new HashedMap();
    private InterceptorBuilderArgs args;
    private boolean isDistribute;

    public InterceptorBuilder(InterceptorBuilderArgs args) {
        this.args = args;
        this.args.getCommit().addActionListener(new AddConditionActionListener());
        this.args.getClear().addActionListener(e -> {
            this.conditions.clear();
            this.comboxs.clear();
            this.distributes.clear();
            args.getInterceptorContainer().removeAll();
            args.getInterceptorContainer().repaint();
            args.getInterceptorContainer().updateUI();
        });
        this.args.getIsDistribute().addActionListener(e -> {
            this.isDistribute = args.getIsDistribute().isSelected();
        });
        this.InitComBox();
    }

    private void InitComBox() {
        for (ComBoxItemBean bean : InterceptorTools.GetTypes()) {
            this.args.getRule().addItem(bean);
        }
    }

    public boolean CheckReceive(String prefix, String info, boolean isHex) {
        if (this.comboxs.size() < 1) {
            return false;
        }
        boolean result = false;
        for (String index : this.comboxs.keySet()) {
            JComboBox<ComBoxItemBean> comBox = this.comboxs.get(index);
            String value = ((ComBoxItemBean)Objects.requireNonNull(comBox.getSelectedItem())).getKey();
            boolean flag = InterceptorTools.DoCheckValue(index, value, info, isHex);
            boolean bl = result = result || flag;
            if (!flag || !this.distributes.containsKey(index)) continue;
            this.distributes.get(index).writeMessage(prefix + info);
        }
        return result;
    }

    private void DoAddCondition(String index, String condition) {
        if (!this.conditions.containsKey(index)) {
            HashMap items = new HashMap();
            this.conditions.put(index, items);
            final JComboBox<ComBoxItemBean> combox = UiFactory.createComboBox(100, null, event -> {});
            this.comboxs.put(index, combox);
            this.args.getInterceptorContainer().add(Box.createRigidArea(UiFactory.HGAP3));
            this.args.getInterceptorContainer().add(combox);
            final PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem1 = new MenuItem();
            MenuItem menuItem2 = new MenuItem();
            menuItem1.setLabel("\u6253\u5f00\u5206\u53d1\u5668");
            menuItem1.setName(index);
            menuItem1.addActionListener(new DistributeActionListener());
            menuItem2.setLabel("\u5173\u95ed\u5206\u53d1\u5668");
            menuItem2.setName(index);
            menuItem2.addActionListener(new CloseMActionListener());
            popupMenu.add(menuItem1);
            popupMenu.add(menuItem2);
            combox.add(popupMenu);
            combox.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int mods = e.getModifiers();
                    if ((mods & 4) != 0) {
                        popupMenu.show(combox, e.getX(), e.getY());
                    }
                }
            });
        }
        if (this.isDistribute) {
            InternalFrame control;
            if (!this.distributes.containsKey(index)) {
                JPanelRecvDistribute distribute = new JPanelRecvDistribute();
                this.distributes.put(index, distribute);
            }
            if ((control = ApplicationParams.AppMainWindow) == null) {
                return;
            }
            String name = index.replace(":", "");
            control.createRecvFrame("\u6d88\u606f\u5206\u53d1:" + name, this.distributes.get(index), InternalFrame.DEMO_FRAME_LAYER, 900, 720);
        } else {
            this.distributes.remove(index);
        }
        Map<String, ComBoxItemBean> values = this.conditions.get(index);
        ComBoxItemBean bean = (ComBoxItemBean)this.args.getRule().getSelectedItem();
        String nCondition = bean.getKey() + condition;
        JComboBox<ComBoxItemBean> box = this.comboxs.get(index);
        if (!values.containsKey(nCondition)) {
            ComBoxItemBean itemBean = index.equals("0") ? new ComBoxItemBean(nCondition, nCondition) : new ComBoxItemBean(nCondition, index + nCondition);
            values.put(nCondition, itemBean);
            box.removeAllItems();
            for (ComBoxItemBean i : values.values()) {
                box.addItem(i);
            }
            this.comboxs.get(index).setSelectedItem(itemBean);
        } else {
            this.comboxs.get(index).setSelectedItem(values.get(nCondition));
        }
    }

    private class CloseMActionListener
    implements ActionListener {
        private CloseMActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuItem item = (MenuItem)e.getSource();
            if (item == null) {
                return;
            }
            String index = item.getName();
            if (index == null || StringUtil.isNull(index).booleanValue()) {
                return;
            }
            String indexS = index;
            if (!InterceptorBuilder.this.comboxs.containsKey(indexS)) {
                return;
            }
            InterceptorBuilder.this.args.getInterceptorContainer().remove((Component)InterceptorBuilder.this.comboxs.get(indexS));
            InterceptorBuilder.this.args.getInterceptorContainer().updateUI();
            InternalFrame control = ApplicationParams.AppMainWindow;
            if (control == null) {
                return;
            }
            InterceptorBuilder.this.conditions.remove(indexS);
            InterceptorBuilder.this.comboxs.remove(indexS);
            if (InterceptorBuilder.this.distributes.containsKey(indexS)) {
                control.remove((Component)InterceptorBuilder.this.distributes.get(indexS));
                InterceptorBuilder.this.distributes.remove(indexS);
            }
        }
    }

    private class DistributeActionListener
    implements ActionListener {
        private DistributeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuItem item = (MenuItem)e.getSource();
            if (item == null) {
                return;
            }
            String index = item.getName();
            if (index == null || StringUtil.isNull(index).booleanValue()) {
                return;
            }
            InternalFrame control = ApplicationParams.AppMainWindow;
            if (control == null) {
                return;
            }
            String name = index.replace(":", "");
            if (!InterceptorBuilder.this.distributes.containsKey(index)) {
                JPanelRecvDistribute distribute = new JPanelRecvDistribute();
                InterceptorBuilder.this.distributes.put(index, distribute);
            }
            control.createRecvFrame("\u6d88\u606f\u5206\u53d1:" + name, (JPanel)InterceptorBuilder.this.distributes.get(index), InternalFrame.DEMO_FRAME_LAYER, 900, 720);
        }
    }

    private class AddConditionActionListener
    implements ActionListener {
        private AddConditionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InterceptorBuilder.this.comboxs.size() >= 10) {
                UiFactory.createMessageDialog("\u9519\u8bef", "\u6700\u591a\u53ea\u80fd\u6dfb\u52a010\u4e2a\u6761\u4ef6", 0);
                return;
            }
            String ruleName = InterceptorBuilder.this.args.getRuleName().getText();
            String condition = InterceptorBuilder.this.args.getCondition().getText();
            String indexValue = InterceptorBuilder.this.args.getIndex().getText();
            if (StringUtil.isNull(condition).booleanValue()) {
                return;
            }
            if (!StringUtil.isNull(indexValue).booleanValue() && !StringUtil.isNumber(indexValue)) {
                UiFactory.createMessageDialog("\u9519\u8bef", "\u4f4d\u7f6e\u4e0b\u6807\u5fc5\u987b\u4e3a\u7eaf\u6570\u5b57", 0);
                return;
            }
            if (StringUtil.isNull(ruleName).booleanValue() && StringUtil.isNull(indexValue).booleanValue()) {
                InterceptorBuilder.this.DoAddCondition("0", condition);
            } else if (StringUtil.isNull(ruleName).booleanValue() && !StringUtil.isNull(indexValue).booleanValue()) {
                if (Integer.parseInt(indexValue) < 1) {
                    UiFactory.createMessageDialog("\u9519\u8bef", "\u4f4d\u7f6e\u4e0b\u6807\u5fc5\u987b\u5927\u4e8e0", 0);
                    return;
                }
                InterceptorBuilder.this.DoAddCondition(indexValue, condition);
            } else if (!StringUtil.isNull(ruleName).booleanValue() && StringUtil.isNull(indexValue).booleanValue()) {
                InterceptorBuilder.this.DoAddCondition(ruleName + ":0", condition);
            } else {
                InterceptorBuilder.this.DoAddCondition(ruleName + ":" + indexValue, condition);
            }
        }
    }
}

