/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network.tools;

import com.simba.common.log.LogManager;
import com.simba.common.utils.StringUtil;
import com.simba.views.network.factory.UiFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FileUtil {
    protected static final Logger logger = Logger.getLogger(FileUtil.class);

    public static boolean WriteConfigFile(String path, List<Map<String, Object>> dt) {
        return FileUtil.WriteFile(dt, path);
    }

    public static Map<String, Object> ReadConfigFile(String path) {
        return FileUtil.ReadFile(path);
    }

    public static boolean ExistConfigFile(String path) {
        File file = new File(path);
        return file.exists();
    }

    private static boolean WriteFile(List<Map<String, Object>> dt, String fileName) {
        try {
            if (dt == null || dt.size() < 1) {
                return false;
            }
            File file = new File(fileName);
            if (!file.exists() && !file.createNewFile()) {
                return false;
            }
            FileWriter writer = new FileWriter(file.getName(), false);
            for (Map<String, Object> map : dt) {
                writer.write(map.get("key") + "[:Key:Value:]" + map.get("value"));
            }
            writer.close();
            return true;
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Write " + fileName + " error: " + ex.getMessage());
            return false;
        }
    }

    private static Map<String, Object> ReadFile(String fileName) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        try {
            String info;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((info = bufferedReader.readLine()) != null) {
                String[] msgList = info.split("\\[:Key:Value:]");
                if (msgList.length < 1) continue;
                if (msgList.length < 2) {
                    infos.put("*", msgList[0]);
                    continue;
                }
                infos.put(msgList[0], msgList[1]);
            }
            bufferedReader.close();
            reader.close();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Read " + fileName + " error: " + ex.getMessage());
        }
        return infos;
    }

    public static String ReadText(String fileName) {
        StringBuilder infos = new StringBuilder();
        try {
            String info;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((info = bufferedReader.readLine()) != null) {
                infos.append(info).append("\r\n");
                if (infos.length() <= 0xA00000) continue;
                bufferedReader.close();
                reader.close();
                UiFactory.createMessageDialog("\u9519\u8bef", "\u6587\u4ef6\u8fc7\u5927", 0);
                return "";
            }
            bufferedReader.close();
            reader.close();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Read " + fileName + " error: " + ex.getMessage());
        }
        return infos.toString();
    }

    public static boolean SaveText(String fileName, String data) {
        try {
            if (StringUtil.isNull(data).booleanValue()) {
                return false;
            }
            if (data.length() > 0xA00000) {
                UiFactory.createMessageDialog("\u9519\u8bef", "\u6570\u636e\u91cf\u8fc7\u5927", 0);
                return false;
            }
            File file = new File(fileName);
            if (!file.exists() && !file.createNewFile()) {
                UiFactory.createMessageDialog("\u9519\u8bef", "\u521b\u5efa\u6587\u4ef6\u5931\u8d25", 0);
                return false;
            }
            FileWriter writer = new FileWriter(fileName, false);
            writer.write(data);
            writer.close();
            return true;
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Write " + fileName + " error: " + ex.getMessage());
            return false;
        }
    }
}

