/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network.items;

import com.simba.common.log.LogManager;
import com.simba.common.utils.StringUtil;
import com.simba.net.base.NetChannel;
import com.simba.views.network.factory.UiFactory;
import com.simba.views.network.items.JItemRecv;
import com.simba.views.network.tools.FileUtil;
import com.simba.views.network.ui.ComBoxItemBean;
import com.simba.views.network.ui.STextPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class JItemSend
extends JPanel {
    protected static final Logger logger = Logger.getLogger(JItemSend.class);
    private final JSplitPane splitPane;
    private boolean isTime;
    private boolean isHex;
    private int headerSize;
    private boolean isTaskRun;
    private String messages = "";
    private ArrayList<Integer> currentIndexs;
    private JItemRecv recv;
    private Map<String, NetChannel> list;
    private JComboBox<ComBoxItemBean> pcbHeaderSize;
    private JCheckBox cbIsHex;
    private JCheckBox cbIsTime;
    private STextPane tbContentSend;
    private JLabel tbByteCount;
    private JSpinner tbTime;
    private JButton openButton;
    private JButton saveButton;
    private ExecutorService executor;

    public JItemSend() {
        this.setLayout(new BorderLayout());
        JPanel left = this.createLeftSplitPaneControls();
        JPanel right = this.createRightSplitPaneControls();
        this.splitPane = new JSplitPane(1, left, right);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setDividerLocation(160);
        this.splitPane.setDividerSize(5);
        this.add((Component)this.splitPane, "Center");
        this.setBackground(Color.white);
        this.currentIndexs = new ArrayList();
    }

    public boolean getIsHex() {
        return this.isHex;
    }

    public void setRecvItem(JItemRecv itemRecv) {
        this.recv = itemRecv;
    }

    public void setChannels(Map<String, NetChannel> channelsList) {
        this.list = channelsList;
    }

    public void enableHeaderSize(boolean enable) {
        this.pcbHeaderSize.setSelectedIndex(0);
        this.headerSize = 0;
        this.pcbHeaderSize.setEnabled(!enable);
    }

    private String doMessage(String msg) {
        Random random = new Random();
        String rule = "(\\$|\\*)\\(.*?\\)";
        int i = 0;
        Pattern r = Pattern.compile(rule);
        Matcher match = r.matcher(msg);
        while (match.find()) {
            String item;
            String[] values;
            String newValue;
            String value = match.group();
            if (value.contains("*")) {
                newValue = value.replace("*(", "");
                newValue = newValue.replace(")", "");
                values = this.getValueRange(newValue);
                item = values[random.nextInt(values.length)];
            } else {
                newValue = value.replace("$(", "");
                newValue = newValue.replace(")", "");
                values = this.getValueRange(newValue);
                int currentIndex = 0;
                if (i < this.currentIndexs.size()) {
                    currentIndex = this.currentIndexs.get(i);
                } else {
                    this.currentIndexs.add(currentIndex);
                }
                if (currentIndex >= values.length) {
                    currentIndex = 0;
                    this.currentIndexs.set(i, 0);
                }
                item = values[currentIndex];
                int index = this.currentIndexs.get(i);
                this.currentIndexs.set(i, ++index);
                ++i;
            }
            String beginMsg = msg.substring(0, match.start());
            String endMsg = msg.substring(match.start() + value.length());
            if (this.isHex) {
                try {
                    int intValue = Integer.valueOf(item, 10);
                    if (intValue < 0 || intValue > 255) {
                        this.recv.WriteMessage("Java\u724816\u8fdb\u5236Byte\u5b57\u8282\u53d6\u503c\u8303\u56f4\u662f0-255\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", Color.red);
                        return "";
                    }
                    byte hexValue = (byte)intValue;
                    msg = beginMsg + String.format("%02X", hexValue) + endMsg;
                }
                catch (Exception e) {
                    this.recv.WriteMessage("Java\u724816\u8fdb\u5236Byte\u5b57\u8282\u53d6\u503c\u8303\u56f4\u662f0-255\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", Color.red);
                    return "";
                }
            } else {
                msg = beginMsg + item + endMsg;
            }
            match = r.matcher(msg);
        }
        return msg;
    }

    private String[] getValueRange(String item) {
        try {
            if (item.contains(",")) {
                String[] value = item.split(",");
                return value;
            }
            if (item.contains("-")) {
                String[] vs = item.split("-");
                if (vs.length > 1) {
                    int v1 = Integer.parseInt(vs[0]);
                    int v2 = Integer.parseInt(vs[1]);
                    int v3 = v2 - v1 + 1;
                    String[] value = new String[v3];
                    for (int i = 0; i < v3; ++i) {
                        value[i] = v1 + i + "";
                    }
                    return value;
                }
                return new String[]{item.replace("-", "")};
            }
            return new String[]{item};
        }
        catch (Exception e) {
            this.recv.WriteMessage("\u89c4\u5219\u89e3\u6790\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5:" + item, Color.red);
            return new String[]{""};
        }
    }

    private void send(String msg) {
        if (StringUtil.isNull(msg).booleanValue()) {
            return;
        }
        byte[] message = this.isHex ? StringUtil.stringToByteArray(msg) : msg.getBytes();
        boolean isSend = false;
        for (NetChannel client : this.list.values()) {
            if (!client.isSelected() || !client.isConnected()) continue;
            if (this.headerSize == 2 || this.headerSize == 4) {
                client.sendContentWithLength(message, this.headerSize);
            } else {
                client.sendContentWithLength(message, 0);
            }
            isSend = true;
        }
        if (this.recv != null) {
            String info;
            if (isSend) {
                info = "S-[" + StringUtil.getDateNow("HH:mm:ss") + "] --> " + msg;
                this.recv.WriteMessage(info, Color.red);
            } else {
                info = "\u53d1\u9001\u5931\u8d25\uff01\u672a\u53d1\u73b0\u53ef\u7528\u8fde\u63a5\uff01";
                this.recv.WriteMessage(info, Color.red);
            }
        }
    }

    private void sendMessageToServer() {
        if (StringUtil.isNull(this.messages).booleanValue()) {
            return;
        }
        if (this.list == null) {
            return;
        }
        this.messages = this.messages.replace("\r\n", "");
        String[] msgList = this.messages.split("<s-[0-9]*>");
        String[] sleepList = new String[msgList.length];
        Pattern r = Pattern.compile("<s-([0-9]*)>");
        Matcher match = r.matcher(this.messages);
        int j = 0;
        while (match.find()) {
            String sleepTime;
            if (match.groupCount() != 1) continue;
            sleepList[j] = sleepTime = match.group(1);
            ++j;
        }
        for (int i = 0; i < msgList.length; ++i) {
            String message = msgList[i];
            if (message.startsWith("#")) continue;
            if ((message.contains("*(") || message.contains("$(")) && (message.contains("-") || message.contains(","))) {
                String msg = this.doMessage(message);
                this.send(msg);
            } else {
                this.send(message);
            }
            if (sleepList[i] == null) continue;
            try {
                Thread.sleep(Integer.parseInt(sleepList[i]));
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void doSendTask(String commend) {
        if (this.isTaskRun) {
            UiFactory.createMessageDialog("\u9519\u8bef", "\u53d1\u9001\u4efb\u52a1\u6b63\u5728\u6267\u884c", 2);
            return;
        }
        this.isTaskRun = true;
        String time = commend;
        if (commend == null) {
            time = "1000";
        }
        if (StringUtil.isNull(time).booleanValue()) {
            time = "1000";
        }
        if (Integer.parseInt(time) < 5) {
            UiFactory.createMessageDialog("\u9519\u8bef", "\u95f4\u9694\u65f6\u95f4\u6700\u5c11\u4e3a5\u6beb\u79d2", 2);
            this.isTaskRun = false;
            return;
        }
        do {
            this.sendMessageToServer();
            if (!this.isTime) break;
            try {
                Thread.sleep(Integer.parseInt(time));
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (this.isTime);
        this.isTaskRun = false;
    }

    private void doSendOnce() {
        if (this.isTaskRun) {
            UiFactory.createMessageDialog("\u9519\u8bef", "\u53d1\u9001\u4efb\u52a1\u6b63\u5728\u6267\u884c", 2);
            return;
        }
        this.isTaskRun = true;
        this.sendMessageToServer();
        this.isTaskRun = false;
    }

    private void statisticsByteCount() {
        String text = this.tbContentSend.getText();
        if (StringUtil.isNull(text).booleanValue()) {
            this.tbByteCount.setText("0");
            return;
        }
        int count = this.isHex ? text.trim().split(" ").length : text.length();
        this.tbByteCount.setText(count + "");
    }

    private JPanel createRightSplitPaneControls() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setMinimumSize(new Dimension(0, 0));
        STextPane editor = new STextPane();
        editor.setEditable(true);
        editor.setBorder(null);
        editor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (JItemSend.this.currentIndexs.size() != 0) {
                    JItemSend.this.currentIndexs.clear();
                }
                JItemSend.this.statisticsByteCount();
            }
        });
        this.tbContentSend = editor;
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(editor);
        controlPanel.add(scroller);
        Box box = UiFactory.createHorizontalBox();
        JLabel label = new JLabel("0");
        label.setSize(new Dimension(30, 30));
        this.tbByteCount = label;
        box.add(label);
        box.add(Box.createHorizontalGlue());
        box.add(UiFactory.createPanel(UiFactory.createButton("\u53d1\u9001", e -> {
            if (StringUtil.isNull(this.tbContentSend.getText()).booleanValue()) {
                return;
            }
            this.messages = this.tbContentSend.getText();
            if (this.executor == null) {
                this.executor = Executors.newCachedThreadPool();
            }
            this.executor.submit(this::doSendOnce);
        }), 75, 30));
        controlPanel.add(box);
        return controlPanel;
    }

    private JPanel createLeftSplitPaneControls() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setMinimumSize(new Dimension(0, 0));
        Box box = UiFactory.createVerticalBox();
        this.cbIsHex = UiFactory.createCheckBox("HEX\u53d1\u9001", new CbIsHexActionListener());
        box.add(this.cbIsHex);
        controlPanel.add(box);
        box = UiFactory.createVerticalBox();
        ArrayList<ComBoxItemBean> dataList = new ArrayList<ComBoxItemBean>();
        dataList.add(new ComBoxItemBean("0", "\u65e0\u957f\u5ea6\u4f4d"));
        dataList.add(new ComBoxItemBean("2", "2\u957f\u5ea6\u4f4d"));
        dataList.add(new ComBoxItemBean("4", "4\u957f\u5ea6\u4f4d"));
        this.pcbHeaderSize = UiFactory.createComboBox(100, dataList, event -> {
            ComBoxItemBean bean = (ComBoxItemBean)this.pcbHeaderSize.getSelectedItem();
            String size = bean.getKey();
            this.headerSize = StringUtil.isNull(size) != false ? 0 : (!StringUtil.isNumber(size) ? 0 : Integer.parseInt(size));
            this.messages = this.tbContentSend.getText();
        });
        box.add(UiFactory.createPanel("\u957f\u5ea6\uff1a", this.pcbHeaderSize));
        this.tbTime = UiFactory.createSpinner(100, 1000, 10, 100000, 100);
        box.add(UiFactory.createPanel("\u95f4\u9694\uff1a", this.tbTime));
        controlPanel.add(box);
        box = UiFactory.createVerticalBox();
        this.cbIsTime = UiFactory.createCheckBox("\u5b9a\u65f6\u53d1\u9001", e -> {
            this.messages = this.tbContentSend.getText();
            if (this.cbIsTime.isSelected()) {
                this.isTime = true;
                if (!this.isTaskRun) {
                    if (this.executor == null) {
                        this.executor = Executors.newCachedThreadPool();
                    }
                    this.executor.submit(() -> this.doSendTask(this.tbTime.getValue().toString()));
                }
            } else {
                this.isTime = false;
            }
        });
        box.add(this.cbIsTime);
        controlPanel.add(box);
        box = UiFactory.createHorizontalBox();
        box.add(Box.createRigidArea(UiFactory.HGAP5));
        this.openButton = UiFactory.createButton("\u8f7d\u5165\u6587\u4ef6", e -> {
            if (this.openButton == null) {
                return;
            }
            JFileChooser fileChooser = new JFileChooser();
            int returnVal = fileChooser.showOpenDialog(this.openButton);
            if (returnVal != 0) {
                return;
            }
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            String data = FileUtil.ReadText(path);
            if (StringUtil.isNull(data).booleanValue()) {
                UiFactory.createMessageDialog("\u63d0\u793a", "\u65e0\u6570\u636e", 2);
                return;
            }
            this.tbContentSend.setText(data);
        });
        box.add(UiFactory.createPanel(this.openButton, 80, 30));
        box.add(Box.createRigidArea(UiFactory.HGAP5));
        this.saveButton = UiFactory.createButton("\u4fdd\u5b58\u6570\u636e", e -> {
            if (this.tbContentSend.getText().length() < 1) {
                UiFactory.createMessageDialog("\u63d0\u793a", "\u5f53\u524d\u65e0\u6570\u636e, \u5bfc\u51fa\u64cd\u4f5c\u53d6\u6d88", 2);
                return;
            }
            if (this.openButton == null) {
                return;
            }
            JFileChooser fileChooser = new JFileChooser();
            int returnVal = fileChooser.showSaveDialog(this.openButton);
            if (returnVal != 0) {
                return;
            }
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            fileChooser.setSelectedFile(new File("send_config.msg"));
            boolean flag = FileUtil.SaveText(path, this.tbContentSend.getText());
            UiFactory.createMessageDialog("\u63d0\u793a", flag ? "\u4fdd\u5b58\u6210\u529f" : "\u4fdd\u5b58\u5931\u8d25", 2);
        });
        box.add(UiFactory.createPanel(this.saveButton, 80, 30));
        box.add(Box.createHorizontalGlue());
        controlPanel.add(box);
        controlPanel.add(Box.createVerticalGlue());
        return controlPanel;
    }

    private class CbIsHexActionListener
    implements ItemListener {
        private CbIsHexActionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JItemSend.this.isHex = JItemSend.this.cbIsHex.isSelected();
            String text = JItemSend.this.tbContentSend.getText().trim();
            if (StringUtil.isNull(text).booleanValue()) {
                JItemSend.this.messages = "";
                return;
            }
            try {
                boolean flag;
                String tempValue = text;
                String msgValue = "";
                String rule = "(\\$|\\*)\\(.*?\\)";
                do {
                    Pattern r;
                    Matcher match;
                    if (flag = (match = (r = Pattern.compile(rule)).matcher(tempValue)).find()) {
                        String value = match.group();
                        String beginMsg = tempValue.substring(0, match.start());
                        String endMsg = tempValue.substring(match.start() + value.length());
                        if (JItemSend.this.cbIsHex.isSelected()) {
                            if (!StringUtil.isNull(beginMsg).booleanValue()) {
                                beginMsg = StringUtil.byteArrayToString(beginMsg.getBytes()) + " ";
                            }
                            value = value + " ";
                        } else if (!StringUtil.isNull(beginMsg).booleanValue()) {
                            beginMsg = new String(StringUtil.stringToByteArray(beginMsg));
                        }
                        msgValue = msgValue + beginMsg + value;
                        tempValue = endMsg;
                        continue;
                    }
                    msgValue = StringUtil.isNull(tempValue) != false ? msgValue.trim() : (JItemSend.this.cbIsHex.isSelected() ? msgValue + StringUtil.byteArrayToString(tempValue.getBytes()) : msgValue + new String(StringUtil.stringToByteArray(tempValue)));
                } while (flag);
                JItemSend.this.tbContentSend.setText(msgValue);
            }
            catch (Exception ex) {
                LogManager.LogError(logger, "catch a exception:" + ex.getMessage());
            }
            JItemSend.this.messages = JItemSend.this.tbContentSend.getText();
        }
    }
}

