/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network.items;

import com.simba.common.log.LogManager;
import com.simba.common.utils.StringUtil;
import com.simba.views.main.InternalFrame;
import com.simba.views.main.manager.ApplicationParams;
import com.simba.views.network.JPanelConfig;
import com.simba.views.network.factory.UiFactory;
import com.simba.views.network.tools.InterceptorBuilder;
import com.simba.views.network.tools.InterceptorBuilderArgs;
import com.simba.views.network.tools.InterceptorTools;
import com.simba.views.network.tools.ModelUtils;
import com.simba.views.network.ui.ComBoxItemBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class JItemRecv
extends JPanel {
    protected static final Logger logger = Logger.getLogger(JItemRecv.class);
    public static final int FontLogSize = 14;
    private int logLineCount;
    private static final int MaxLogLine = 1000;
    private boolean isHexReceive;
    private boolean isRemoveFourLength;
    private boolean isAutoCallback;
    private boolean isLogging;
    private boolean isStopReceive;
    private String logFileName;
    private InterceptorBuilder interceptor;
    private final JSplitPane splitPane;
    private JPanelConfig config;
    private JTextField tbRuleName;
    private JTextField tbCondition;
    private JTextField tbIndex;
    private JComboBox<ComBoxItemBean> pcbRule;
    private JButton btnAddCondition;
    private JButton btnClearCondition;
    private JPanel spConditions;
    private JCheckBox cbIsDistribute;
    private JCheckBox cbIsRemoveFourLength;
    private JTextPane rtReceiveInfo;
    private JCheckBox cbIsHexReceive;
    private JCheckBox cbIsAutoCallback;
    private JCheckBox cbIsLogging;
    private JCheckBox cbIsStopReceive;

    public JItemRecv() {
        this.setLayout(new BorderLayout());
        JPanel left = this.createLeftSplitPaneControls();
        JPanel right = this.createRightSplitPaneControls();
        this.splitPane = new JSplitPane(1, left, right);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setDividerLocation(160);
        this.splitPane.setDividerSize(5);
        this.add((Component)this.splitPane, "Center");
        this.setBackground(Color.white);
        this.builderInterceptor();
        this.config = new JPanelConfig();
        Random random = new Random();
        this.WriteMessage(ModelUtils.getModel(random.nextInt(30)));
    }

    public void setLogFileName(String fileName) {
        this.logFileName = fileName;
    }

    public void enableHeaderSize(boolean enable) {
        this.cbIsRemoveFourLength.setSelected(false);
        this.isRemoveFourLength = false;
        this.cbIsRemoveFourLength.setEnabled(!enable);
    }

    public Map<String, String> getAutoCallbackRules() {
        return this.config.GetRules();
    }

    private void builderInterceptor() {
        InterceptorBuilderArgs args = new InterceptorBuilderArgs();
        args.setUser(this);
        args.setRuleName(this.tbRuleName);
        args.setCondition(this.tbCondition);
        args.setIndex(this.tbIndex);
        args.setRule(this.pcbRule);
        args.setCommit(this.btnAddCondition);
        args.setClear(this.btnClearCondition);
        args.setInterceptorContainer(this.spConditions);
        args.setIsDistribute(this.cbIsDistribute);
        this.interceptor = new InterceptorBuilder(args);
    }

    public void WriteMessage(String message) {
        this.doLogShow(this.rtReceiveInfo, message, Color.BLUE);
    }

    public void WriteMessage(String message, Color color) {
        this.doLogShow(this.rtReceiveInfo, message, color);
    }

    public void doJsonMessageHandler(byte[] message, Channel channel) {
        try {
            byte[] content;
            if (this.isStopReceive) {
                return;
            }
            if (this.isRemoveFourLength) {
                if (message.length > 4) {
                    content = new byte[message.length - 4];
                    System.arraycopy(message, 4, content, 0, content.length);
                } else {
                    content = message;
                }
            } else {
                content = message;
            }
            String msg = this.isHexReceive ? StringUtil.byteArrayToString(content) : new String(content);
            SocketAddress point = channel.getRemoteAddress();
            InetSocketAddress ipPoint = (InetSocketAddress)point;
            Inet4Address ip = (Inet4Address)ipPoint.getAddress();
            String host = ip.toString();
            int port = ipPoint.getPort();
            String prefix = "R-[" + StringUtil.getDateNow("HH:mm:ss") + "]-[" + host.replace("/", "") + ":" + port + "] --> ";
            if (this.interceptor.CheckReceive(prefix, msg, this.isHexReceive)) {
                return;
            }
            this.WriteMessage(prefix + msg);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    private void doLogShow(JTextPane richTxtBox, String info, Color color) {
        if (richTxtBox == null) {
            return;
        }
        try {
            SwingUtilities.invokeLater(() -> {
                if (StringUtil.isNull(info).booleanValue()) {
                    return;
                }
                if (this.logLineCount >= 1000) {
                    richTxtBox.setText("");
                    this.logLineCount = 0;
                }
                ++this.logLineCount;
                SimpleAttributeSet set = new SimpleAttributeSet();
                StyleConstants.setItalic(set, false);
                StyleConstants.setForeground(set, color);
                StyleConstants.setFontSize(set, 14);
                StyledDocument doc = richTxtBox.getStyledDocument();
                try {
                    doc.insertString(doc.getLength(), info + "\r\n", set);
                    richTxtBox.setCaretPosition(doc.getLength());
                }
                catch (BadLocationException e) {
                    LogManager.LogError(logger, "\u63d2\u5165\u6587\u5b57\u4f4d\u7f6e\u4e0d\u5bf9:" + info);
                }
            });
        }
        catch (Exception e) {
            LogManager.LogError(logger, "\u663e\u793a\u6587\u5b57\u53d1\u751f\u5f02\u5e38:" + info);
        }
    }

    public String doAutoCallback(byte[] content) {
        if (this.isAutoCallback && content != null && content.length > 0) {
            Map<String, String> rules = this.getAutoCallbackRules();
            for (String ruleKey : rules.keySet()) {
                String msg;
                String[] ruleInfo = ruleKey.split("@");
                if (ruleInfo.length < 1) continue;
                String string = msg = this.isHexReceive ? StringUtil.byteArrayToString(content) : new String(content);
                if (!InterceptorTools.DoCheckValue(ruleInfo[0], '@' + ruleInfo[1], msg, this.isHexReceive)) continue;
                return rules.get(ruleKey);
            }
        }
        return null;
    }

    private JPanel createRightSplitPaneControls() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        this.spConditions = new JPanel();
        this.spConditions.setLayout(new BoxLayout(this.spConditions, 0));
        this.spConditions.setAlignmentX(0.0f);
        this.spConditions.setAlignmentY(0.0f);
        this.spConditions.setMaximumSize(new Dimension(2000, 30));
        controlPanel.add(this.spConditions);
        JTextPane editor = new JTextPane();
        editor.setEditable(false);
        editor.setBorder(null);
        JScrollPane scroller = new JScrollPane();
        scroller.setMinimumSize(new Dimension(0, 0));
        JViewport vp = scroller.getViewport();
        vp.add(editor);
        this.rtReceiveInfo = editor;
        controlPanel.add(scroller);
        return controlPanel;
    }

    private JPanel createLeftSplitPaneControls() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setMinimumSize(new Dimension(0, 0));
        Box box = UiFactory.createVerticalBox();
        this.cbIsHexReceive = UiFactory.createCheckBox("HEX\u63a5\u6536", e -> {
            this.isHexReceive = this.cbIsHexReceive.isSelected();
        });
        box.add(this.cbIsHexReceive);
        this.cbIsRemoveFourLength = UiFactory.createCheckBox("\u6e05\u9664\u56db\u4f4d\u957f\u5ea6\u7b26", e -> {
            this.isRemoveFourLength = this.cbIsRemoveFourLength.isSelected();
        });
        box.add(this.cbIsRemoveFourLength);
        this.cbIsLogging = UiFactory.createCheckBox("\u662f\u5426\u8bb0\u5f55\u65e5\u5fd7", e -> {
            this.isLogging = this.cbIsLogging.isSelected();
        });
        box.add(this.cbIsLogging);
        this.cbIsStopReceive = UiFactory.createCheckBox("\u6682\u505c\u63a5\u6536\u4fe1\u606f", e -> {
            this.isStopReceive = this.cbIsStopReceive.isSelected();
        });
        box.add(this.cbIsStopReceive);
        this.cbIsAutoCallback = UiFactory.createCheckBox("\u81ea\u52a8\u56de\u4f20", e -> {
            this.isAutoCallback = this.cbIsAutoCallback.isSelected();
        });
        box.add(this.cbIsAutoCallback);
        controlPanel.add(box);
        box = UiFactory.createVerticalBox();
        box.add(UiFactory.createPanel(UiFactory.createButton("\u56de\u4f20\u89c4\u5219", e -> {
            InternalFrame control = ApplicationParams.AppMainWindow;
            if (control == null) {
                return;
            }
            control.createRecvFrame("\u89c4\u5219\u914d\u7f6e", this.config, InternalFrame.DEMO_FRAME_LAYER, 900, 720);
        }), 170, 30));
        box.add(Box.createRigidArea(UiFactory.VGAP5));
        box.add(UiFactory.createPanel(UiFactory.createButton("\u6e05\u7a7a\u9762\u677f", e -> this.rtReceiveInfo.setText("")), 170, 30));
        box.add(Box.createRigidArea(UiFactory.VGAP5));
        controlPanel.add(box);
        box = UiFactory.createVerticalBox();
        this.tbRuleName = UiFactory.createTextBox(100);
        box.add(UiFactory.createPanel("\u89c4\u5219\u540d\uff1a", this.tbRuleName));
        this.tbCondition = UiFactory.createTextBox(100);
        box.add(UiFactory.createPanel("\u6761\u4ef6\uff1a  ", this.tbCondition));
        this.tbIndex = UiFactory.createTextBox(100);
        box.add(UiFactory.createPanel("\u4f4d\u7f6e\uff1a  ", this.tbIndex));
        this.pcbRule = UiFactory.createComboBox(100, null, e -> {});
        box.add(UiFactory.createPanel("\u89c4\u5219\uff1a  ", this.pcbRule));
        controlPanel.add(box);
        box = UiFactory.createVerticalBox();
        this.cbIsDistribute = UiFactory.createCheckBox("\u662f\u5426\u5206\u53d1(\u65b0\u7a97\u53e3\u663e\u793a)", e -> {});
        box.add(this.cbIsDistribute);
        controlPanel.add(box);
        box = UiFactory.createHorizontalBox();
        box.add(Box.createRigidArea(UiFactory.HGAP5));
        this.btnAddCondition = UiFactory.createButton("\u6dfb\u52a0\u6761\u4ef6", null);
        box.add(UiFactory.createPanel(this.btnAddCondition, 80, 30));
        box.add(Box.createRigidArea(UiFactory.HGAP5));
        this.btnClearCondition = UiFactory.createButton("\u6e05\u7a7a\u6761\u4ef6", null);
        box.add(UiFactory.createPanel(this.btnClearCondition, 80, 30));
        box.add(Box.createHorizontalGlue());
        controlPanel.add(box);
        return controlPanel;
    }
}

