/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network.factory;

import com.simba.views.network.ui.ComBoxItemBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class UiFactory {
    public static final Dimension HGAP5 = new Dimension(5, 1);
    public static final Dimension HGAP3 = new Dimension(3, 1);
    public static final Dimension VGAP5 = new Dimension(1, 5);
    public static final Dimension VGAP10 = new Dimension(1, 10);
    public static final Dimension HGAP15 = new Dimension(15, 1);
    public static final Dimension VGAP15 = new Dimension(1, 15);

    public static Box createVerticalBox() {
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        box.setAlignmentY(0.0f);
        return box;
    }

    public static Box createHorizontalBox() {
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.setAlignmentY(0.0f);
        return box;
    }

    public static void createMessageDialog(String title, String content, int type) {
        JFrame frame = new JFrame(title);
        frame.setSize(400, 400);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        JOptionPane.showMessageDialog(frame, content, title, type);
    }

    public static int createConfirmDialog(String title, String content) {
        JFrame frame = new JFrame(title);
        frame.setSize(400, 400);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        return JOptionPane.showConfirmDialog(frame, content, title, 1);
    }

    public static JCheckBox createCheckBox(String text, ItemListener listener) {
        JCheckBox checkBox = new JCheckBox(text);
        checkBox.setSelected(false);
        checkBox.addItemListener(listener);
        return checkBox;
    }

    public static JButton createButton(String text, ActionListener listener) {
        JButton button = new JButton(text);
        button.addActionListener(listener);
        return button;
    }

    public static JTextField createTextBox(int width) {
        JTextField textField = new JTextField();
        textField.setMaximumSize(new Dimension(width, 30));
        textField.setPreferredSize(new Dimension(width, 30));
        return textField;
    }

    public static JComboBox<ComBoxItemBean> createComboBox(int width, ArrayList<ComBoxItemBean> data, ActionListener listener) {
        if (data == null) {
            data = new ArrayList();
        }
        ComBoxItemBean[] items = new ComBoxItemBean[data.size()];
        JComboBox<ComBoxItemBean> comboBox = new JComboBox<ComBoxItemBean>(data.toArray(items));
        comboBox.addActionListener(listener);
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = value == null ? "" : ((ComBoxItemBean)value).getValue();
                return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
            }
        });
        comboBox.setMaximumSize(new Dimension(width, 30));
        comboBox.setPreferredSize(new Dimension(width, 30));
        return comboBox;
    }

    public static JSpinner createSpinner(int width, int value, int min, int max, int step) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(value, min, max, step));
        spinner.setMaximumSize(new Dimension(width, 30));
        spinner.setPreferredSize(new Dimension(width, 30));
        return spinner;
    }

    public static JPanel createPanel(String text, Component component) {
        JLabel label = new JLabel(text);
        label.setLabelFor(component);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(3, 3, 3, 3));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add((Component)label, "West");
        panel.add(Box.createRigidArea(HGAP5));
        panel.add(component, "Center");
        return panel;
    }

    public static JPanel createPanel(JButton button, int maxWidth, int maxHeight) {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(0, 3, 0, 3));
        panel.setLayout(new GridLayout(1, 1));
        panel.setMaximumSize(new Dimension(maxWidth, maxHeight));
        panel.setPreferredSize(new Dimension(maxWidth, maxHeight));
        panel.add(button);
        return panel;
    }
}

