/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network;

import com.simba.business.OnTimeTickListener;
import com.simba.business.ServerTimeTickManager;
import com.simba.common.utils.StringUtil;
import com.simba.net.base.NetChannel;
import com.simba.net.base.events.OnReceivedEvent;
import com.simba.net.server.NetServerManager;
import com.simba.net.server.tools.JsonContentServer;
import com.simba.net.server.tools.JsonServerClient;
import com.simba.views.network.factory.UiFactory;
import com.simba.views.network.items.JItemRecv;
import com.simba.views.network.items.JItemSend;
import com.simba.views.network.tables.client.ClientTable;
import com.simba.views.network.tables.client.ClientTableModel;
import com.simba.views.network.ui.ComBoxItemBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableCellEditor;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;

public class JPanelServer
extends JPanel
implements OnTimeTickListener,
InternalFrameListener {
    private static final Insets insets = new Insets(4, 8, 4, 8);
    public static final String PanelName = "PanelServer";
    private boolean uLock;
    private JsonContentServer server;
    private boolean tryConnection = true;
    private boolean currentStatus;
    private JItemRecv recvItem;
    private JItemSend sendItem;
    private JComboBox<ComBoxItemBean> pcbHeaderSize;
    private JSpinner portInfo;
    private JButton btnLink;
    private JTable dataGridLinkList;
    public String serverName;

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public JPanelServer(String serverName) {
        this.setLayout(new BorderLayout());
        this.recvItem = new JItemRecv();
        this.recvItem.setMinimumSize(new Dimension(0, 0));
        this.sendItem = new JItemSend();
        this.sendItem.setMinimumSize(new Dimension(0, 0));
        JSplitPane splitPane = new JSplitPane(0, this.recvItem, this.sendItem);
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(false);
        splitPane.setDividerLocation(460);
        splitPane.setDividerSize(5);
        JPanel control = this.createControl();
        JSplitPane content = new JSplitPane(1, splitPane, control);
        content.setContinuousLayout(true);
        content.setOneTouchExpandable(false);
        content.setDividerLocation(670);
        content.setDividerSize(5);
        this.add((Component)content, "Center");
        this.setBackground(Color.white);
        this.serverName = PanelName + serverName;
        this.recvItem.setLogFileName("server_" + serverName);
        this.sendItem.setRecvItem(this.recvItem);
        ServerTimeTickManager.getInstance().addListener(this);
    }

    private JPanel createControl() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setMinimumSize(new Dimension(0, 0));
        Box box = UiFactory.createHorizontalBox();
        Box left = UiFactory.createVerticalBox();
        this.portInfo = UiFactory.createSpinner(70, 6666, 1, 100000, 1);
        this.portInfo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!JPanelServer.this.currentStatus && JPanelServer.this.server != null) {
                    JPanelServer.this.server = null;
                }
            }
        });
        left.add(UiFactory.createPanel("\u7aef\u53e3\uff1a", this.portInfo));
        ArrayList<ComBoxItemBean> dataList = new ArrayList<ComBoxItemBean>();
        dataList.add(new ComBoxItemBean("0", "\u65e0"));
        dataList.add(new ComBoxItemBean("2", "2\u4f4d"));
        dataList.add(new ComBoxItemBean("4", "4\u4f4d"));
        this.pcbHeaderSize = UiFactory.createComboBox(70, dataList, e -> {
            ComBoxItemBean bean;
            String value;
            if (!this.currentStatus && this.server != null) {
                this.server = null;
            }
            if ((value = (bean = (ComBoxItemBean)this.pcbHeaderSize.getSelectedItem()).getKey()).equals("0")) {
                this.recvItem.enableHeaderSize(false);
                this.sendItem.enableHeaderSize(false);
            } else {
                this.recvItem.enableHeaderSize(true);
                this.sendItem.enableHeaderSize(true);
            }
        });
        left.add(UiFactory.createPanel("\u957f\u5ea6\uff1a", this.pcbHeaderSize));
        box.add(left);
        Box right = UiFactory.createVerticalBox();
        this.btnLink = UiFactory.createButton("\u542f\u52a8", e -> {
            if (this.uLock) {
                UiFactory.createMessageDialog("\u63d0\u793a", "\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\uff0c \u8bf7\u7a0d\u540e\uff01", 2);
                return;
            }
            this.uLock = true;
            if (this.server == null) {
                String port = this.portInfo.getValue().toString();
                if (StringUtil.isNull(port).booleanValue()) {
                    this.uLock = false;
                    UiFactory.createMessageDialog("\u63d0\u793a", "\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", 0);
                    return;
                }
                if (!StringUtil.isNumber(port)) {
                    this.uLock = false;
                    UiFactory.createMessageDialog("\u63d0\u793a", "\u7aef\u53e3\u5fc5\u987b\u4e3a\u6570\u5b57\uff01", 0);
                    return;
                }
                if (port.length() < 2 || port.length() > 5) {
                    this.uLock = false;
                    UiFactory.createMessageDialog("\u63d0\u793a", "\u7aef\u53e3\u8303\u56f4\u4e3a10-99999\uff01", 0);
                    return;
                }
                ComBoxItemBean bean = (ComBoxItemBean)this.pcbHeaderSize.getSelectedItem();
                String headerSize = bean.getKey();
                int size = StringUtil.isNull(headerSize) != false ? 0 : (!StringUtil.isNumber(headerSize) ? 0 : Integer.parseInt(headerSize));
                this.server = new JsonContentServer(Integer.parseInt(port), size);
                this.server.addReceivedEvent(new JsonMessageHandler());
                this.server.addActiveEvent((channel, o) -> this.refreshLinkList());
                this.server.addInActiveEvent((channel, o) -> this.refreshLinkList());
                this.sendItem.setChannels(this.server.getClients());
                this.uLock = false;
                return;
            }
            if (this.tryConnection) {
                this.server.create();
            } else {
                this.server.shutDown();
            }
            this.uLock = false;
        });
        right.add(UiFactory.createPanel(this.btnLink, 75, 70));
        box.add(right);
        controlPanel.add(box);
        ClientTable table = new ClientTable();
        this.dataGridLinkList = table.getTable();
        final TableCellEditor editor = this.dataGridLinkList.getColumnModel().getColumn(1).getCellEditor();
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = JPanelServer.this.dataGridLinkList.getSelectedRow();
                if (row != -1) {
                    String id = JPanelServer.this.dataGridLinkList.getValueAt(row, 0).toString();
                    boolean value = (Boolean)editor.getCellEditorValue();
                    JPanelServer.this.server.getClients().get(id).setSelected(value);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        controlPanel.add(table);
        controlPanel.add(Box.createHorizontalGlue());
        return controlPanel;
    }

    private void refreshLinkList() {
        this.dataGridLinkList.removeAll();
        ClientTableModel model = (ClientTableModel)this.dataGridLinkList.getModel();
        model.getDataVector().clear();
        model.fireTableDataChanged();
        this.dataGridLinkList.updateUI();
        for (NetChannel client : this.server.getClients().values()) {
            if (!(client instanceof JsonServerClient)) continue;
            JsonServerClient c = (JsonServerClient)client;
            Vector<Object> vector = new Vector<Object>();
            vector.add(c.getId());
            vector.add(c.isSelected());
            vector.add(c.getServerIp().replace("/", ""));
            vector.add(c.getServerPort());
            model.addRow(vector);
        }
    }

    @Override
    public void OnServerTimeTickEvent() {
        if (this.server == null) {
            return;
        }
        if (this.server.isConnected()) {
            if (this.currentStatus) {
                return;
            }
            this.btnLink.setText("\u505c\u6b62");
            this.tryConnection = false;
            this.recvItem.WriteMessage("\u5df2\u542f\u52a8\u670d\u52a1");
            this.currentStatus = true;
            this.portInfo.setEnabled(false);
            this.pcbHeaderSize.setEnabled(false);
        } else {
            if (!this.currentStatus) {
                return;
            }
            this.btnLink.setText("\u542f\u52a8");
            this.tryConnection = true;
            this.recvItem.WriteMessage("\u5df2\u505c\u6b62\u670d\u52a1", Color.red);
            this.currentStatus = false;
            this.portInfo.setEnabled(true);
            this.pcbHeaderSize.setEnabled(true);
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.shutdown();
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    private void shutdown() {
        if (this.server != null) {
            this.server.shutDown();
            this.server = null;
        }
    }

    private class JsonMessageHandler
    implements OnReceivedEvent {
        private JsonMessageHandler() {
        }

        @Override
        public void messageReceived(Object sender, Channel channel, String message, Object content) {
            boolean callbackFlag = false;
            String callbackContent = JPanelServer.this.recvItem.doAutoCallback((byte[])content);
            if (!StringUtil.isNull(callbackContent).booleanValue() && sender instanceof NetServerManager) {
                byte[] sendBuffer = JPanelServer.this.sendItem.getIsHex() ? StringUtil.stringToByteArray(callbackContent) : callbackContent.getBytes();
                ChannelBuffer duplicateBuffer = ChannelBuffers.wrappedBuffer(sendBuffer);
                channel.write(duplicateBuffer);
                callbackFlag = true;
            }
            JPanelServer.this.recvItem.doJsonMessageHandler((byte[])content, channel);
            if (!callbackFlag) {
                return;
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception sendBuffer) {
                // empty catch block
            }
            String info = "A-[" + StringUtil.getDateNow("HH:mm:ss") + "] --> " + callbackContent;
            JPanelServer.this.recvItem.WriteMessage(info, Color.red);
        }
    }
}

