/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network;

import com.simba.common.log.LogManager;
import com.simba.common.utils.StringUtil;
import com.simba.views.network.factory.UiFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class JPanelRecvDistribute
extends JPanel {
    protected static final Logger logger = Logger.getLogger(JPanelRecvDistribute.class);
    private JTextPane rtInfo;
    public static final String PanelName = "RecvDistribute";
    public static final int fontLogSize = 14;
    private int logLineCount;
    private static final int maxLogLine = 1000;

    public JPanelRecvDistribute() {
        this.setLayout(new BorderLayout());
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setMinimumSize(new Dimension(0, 0));
        JTextPane editor = new JTextPane();
        editor.setEditable(false);
        editor.setBorder(null);
        JScrollPane scroller = new JScrollPane();
        scroller.setMinimumSize(new Dimension(0, 0));
        JViewport vp = scroller.getViewport();
        this.rtInfo = editor;
        vp.add(editor);
        controlPanel.add(scroller);
        Box box = UiFactory.createVerticalBox();
        box.add(Box.createRigidArea(UiFactory.VGAP5));
        box.add(UiFactory.createPanel(UiFactory.createButton("\u6e05\u7a7a\u9762\u677f", e -> this.rtInfo.setText("")), 2000, 30));
        box.add(Box.createRigidArea(UiFactory.VGAP5));
        controlPanel.add(box);
        this.add((Component)controlPanel, "Center");
        this.setBackground(Color.white);
    }

    public void writeMessage(String message) {
        this.doLogShow(this.rtInfo, message, Color.BLUE);
    }

    public void writeMessage(String message, Color color) {
        this.doLogShow(this.rtInfo, message, color);
    }

    private void doLogShow(JTextPane richTxtBox, String info, Color color) {
        if (richTxtBox == null) {
            return;
        }
        try {
            SwingUtilities.invokeLater(() -> {
                if (StringUtil.isNull(info).booleanValue()) {
                    return;
                }
                if (this.logLineCount >= 1000) {
                    richTxtBox.setText("");
                    this.logLineCount = 0;
                }
                ++this.logLineCount;
                SimpleAttributeSet set = new SimpleAttributeSet();
                StyleConstants.setItalic(set, true);
                StyleConstants.setForeground(set, color);
                StyleConstants.setFontSize(set, 14);
                StyledDocument doc = richTxtBox.getStyledDocument();
                try {
                    doc.insertString(doc.getLength(), info + "\r\n", set);
                    richTxtBox.setCaretPosition(doc.getLength());
                }
                catch (BadLocationException e) {
                    LogManager.LogError(logger, "\u63d2\u5165\u6587\u5b57\u4f4d\u7f6e\u4e0d\u5bf9:" + info);
                }
            });
        }
        catch (Exception e) {
            LogManager.LogError(logger, "\u663e\u793a\u6587\u5b57\u53d1\u751f\u5f02\u5e38:" + info);
        }
    }
}

