/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network;

import com.simba.common.utils.StringUtil;
import com.simba.views.network.factory.UiFactory;
import com.simba.views.network.tables.config.ConfigTable;
import com.simba.views.network.tables.config.ConfigTableModel;
import com.simba.views.network.tools.FileUtil;
import com.simba.views.network.tools.InterceptorTools;
import com.simba.views.network.ui.ComBoxItemBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class JPanelConfig
extends JPanel {
    public static final String PanelName = "PanelConfig";
    private ArrayList<Map<String, Object>> dt;
    private Map<String, String> rules;
    private JTextField key;
    private JTextField rule;
    private JTextField index;
    private JComboBox<ComBoxItemBean> filter;
    private JTextField content;
    private JButton btnAdd;
    private JButton btnLoad;
    private JButton btnSave;
    private JTable table;

    public Map<String, String> GetRules() {
        return this.rules;
    }

    public JPanelConfig() {
        this.setLayout(new BorderLayout());
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setMinimumSize(new Dimension(0, 0));
        Box top = UiFactory.createHorizontalBox();
        Box left = UiFactory.createVerticalBox();
        Box leftTop = UiFactory.createHorizontalBox();
        this.key = UiFactory.createTextBox(180);
        leftTop.add(UiFactory.createPanel("\u5173\u952e\u5b57:", this.key));
        this.rule = UiFactory.createTextBox(100);
        leftTop.add(UiFactory.createPanel("\u89c4\u5219\u540d:", this.rule));
        this.index = UiFactory.createTextBox(80);
        leftTop.add(UiFactory.createPanel("\u4e0b\u6807:", this.index));
        this.filter = UiFactory.createComboBox(100, InterceptorTools.GetTypes(), null);
        leftTop.add(UiFactory.createPanel("", this.filter));
        left.add(leftTop);
        Box leftBottom = UiFactory.createHorizontalBox();
        this.content = UiFactory.createTextBox(565);
        leftBottom.add(UiFactory.createPanel("\u5185  \u5bb9:", this.content));
        left.add(leftBottom);
        top.add(left);
        Box right = UiFactory.createHorizontalBox();
        this.btnAdd = UiFactory.createButton("\u6dfb\u52a0\u6761\u4ef6", null);
        right.add(UiFactory.createPanel(this.btnAdd, 80, 70));
        this.btnLoad = UiFactory.createButton("\u52a0\u8f7d\u6587\u4ef6", null);
        right.add(UiFactory.createPanel(this.btnLoad, 80, 70));
        this.btnSave = UiFactory.createButton("\u4fdd\u5b58\u6587\u4ef6", null);
        right.add(UiFactory.createPanel(this.btnSave, 80, 70));
        top.add(right);
        controlPanel.add(top);
        ConfigTable tablePanel = new ConfigTable();
        this.table = tablePanel.getTable();
        controlPanel.add(tablePanel);
        this.add((Component)controlPanel, "Center");
        this.setBackground(Color.white);
        this.dt = new ArrayList();
        this.rules = new HashMap<String, String>();
        this.btnAdd.addActionListener(e -> {
            if (StringUtil.isNull(this.content.getText()).booleanValue()) {
                UiFactory.createMessageDialog("\u9519\u8bef", "\u5185\u5bb9\u503c\u4e0d\u80fd\u4e3a\u7a7a", 0);
                return;
            }
            String condition = this.key.getText();
            String ruleName = this.rule.getText();
            String ruleIndex = this.index.getText();
            if (StringUtil.isNull(condition).booleanValue()) {
                return;
            }
            if (!StringUtil.isNull(ruleIndex).booleanValue() && !StringUtil.isNumber(ruleIndex)) {
                UiFactory.createMessageDialog("\u9519\u8bef", "\u4f4d\u7f6e\u4e0b\u6807\u5fc5\u987b\u4e3a\u7eaf\u6570\u5b57", 0);
                return;
            }
            if (StringUtil.isNull(ruleName).booleanValue() && StringUtil.isNull(ruleIndex).booleanValue()) {
                this.doAddCondition("0", condition);
            } else if (StringUtil.isNull(ruleName).booleanValue() && !StringUtil.isNull(ruleIndex).booleanValue()) {
                if (Integer.parseInt(ruleIndex) < 1) {
                    UiFactory.createMessageDialog("\u9519\u8bef", "\u4f4d\u7f6e\u4e0b\u6807\u5fc5\u987b\u5927\u4e8e0", 0);
                    return;
                }
                this.doAddCondition(ruleIndex, condition);
            } else if (!StringUtil.isNull(ruleName).booleanValue() && StringUtil.isNull(ruleIndex).booleanValue()) {
                this.doAddCondition(ruleName + ":0", condition);
            } else {
                this.doAddCondition(ruleName + ":" + ruleIndex, condition);
            }
            this.refresh();
        });
        this.btnLoad.addActionListener(e -> {
            if (this.btnLoad == null) {
                return;
            }
            JFileChooser fileChooser = new JFileChooser();
            int returnVal = fileChooser.showOpenDialog(this.btnLoad);
            if (returnVal != 0) {
                return;
            }
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            Map<String, Object> dataList = FileUtil.ReadConfigFile(path);
            if (dataList.size() < 1) {
                UiFactory.createMessageDialog("\u8b66\u544a", "\u65e0\u6570\u636e", 2);
                return;
            }
            int result = UiFactory.createConfirmDialog("\u63d0\u793a", "\u662f\u5426\u8ffd\u52a0,\u6ce8\u610f!\u6240\u6709\u91cd\u590d\u952e\u4f1a\u88ab\u5ffd\u7565");
            if (result != 0) {
                this.dt.clear();
                this.rules.clear();
            }
            for (String key : dataList.keySet()) {
                this.addContent(key, dataList.get(key).toString());
            }
            this.refresh();
        });
        this.btnSave.addActionListener(e -> {
            if (this.dt.size() < 1) {
                UiFactory.createMessageDialog("\u8b66\u544a", "\u5f53\u524d\u65e0\u6570\u636e, \u5bfc\u51fa\u64cd\u4f5c\u53d6\u6d88", 2);
                return;
            }
            if (this.btnSave == null) {
                return;
            }
            JFileChooser fileChooser = new JFileChooser();
            int returnVal = fileChooser.showSaveDialog(this.btnSave);
            if (returnVal != 0) {
                return;
            }
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            fileChooser.setSelectedFile(new File("rule.Config"));
            boolean flag = FileUtil.WriteConfigFile(path, this.dt);
            UiFactory.createMessageDialog("\u63d0\u793a", flag ? "\u4fdd\u5b58\u6210\u529f" : "\u4fdd\u5b58\u5931\u8d25", 2);
            this.refresh();
        });
    }

    private void refresh() {
        this.table.removeAll();
        ConfigTableModel model = (ConfigTableModel)this.table.getModel();
        model.getDataVector().clear();
        model.fireTableDataChanged();
        this.table.updateUI();
        model.fireTableDataChanged();
        for (Map<String, Object> client : this.dt) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(client.get("key"));
            vector.add(client.get("value"));
            model.addRow(vector);
        }
    }

    private void doAddCondition(String index, String condition) {
        ComBoxItemBean bean = (ComBoxItemBean)this.filter.getSelectedItem();
        String nCondition = bean.getKey() + condition;
        String key = index.equals("0") ? nCondition : index + nCondition;
        this.addContent(key, this.content.getText());
    }

    private void addContent(String key, String value) {
        for (Map<String, Object> row : this.dt) {
            if (!row.get("key").equals(key)) continue;
            UiFactory.createMessageDialog("\u9519\u8bef", "\u5173\u952e\u5b57'" + key + "'\u5df2\u5b58\u5728", 0);
            return;
        }
        HashMap<String, String> dr = new HashMap<String, String>();
        dr.put("key", key);
        dr.put("value", value);
        this.dt.add(dr);
        this.rules.put(key, value);
    }
}

