/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.network;

import com.simba.business.OnTimeTickListener;
import com.simba.business.ServerTimeTickManager;
import com.simba.common.utils.StringUtil;
import com.simba.net.base.NetChannel;
import com.simba.net.base.events.OnReceivedEvent;
import com.simba.net.client.NetClientManager;
import com.simba.net.client.tools.JsonContentClient;
import com.simba.net.client.tools.JsonSocketFactory;
import com.simba.views.network.factory.UiFactory;
import com.simba.views.network.items.JItemRecv;
import com.simba.views.network.items.JItemSend;
import com.simba.views.network.ui.ComBoxItemBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.jboss.netty.channel.Channel;

public class JPanelClient
extends JPanel
implements OnTimeTickListener,
InternalFrameListener {
    private static final Insets insets = new Insets(4, 8, 4, 8);
    public static final String PanelName = "PanelClient";
    private NetChannel currentClient;
    private boolean tryConnection = true;
    private boolean connAlways;
    private boolean uLock;
    private boolean currentStatus;
    private JsonSocketFactory factory;
    private JItemRecv recvItem;
    private JItemSend sendItem;
    private JComboBox<ComBoxItemBean> pcbHeaderSize;
    private JCheckBox cbIsConnAlways;
    private JButton btnLink;
    private JTextField ipInfo;
    private JSpinner portInfo;
    private String clientName;

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public JPanelClient(String clientName) {
        this.setLayout(new BorderLayout());
        this.recvItem = new JItemRecv();
        this.recvItem.setMinimumSize(new Dimension(0, 0));
        this.sendItem = new JItemSend();
        this.sendItem.setMinimumSize(new Dimension(0, 0));
        JSplitPane splitPane = new JSplitPane(0, this.recvItem, this.sendItem);
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(false);
        splitPane.setDividerLocation(460);
        splitPane.setDividerSize(5);
        JPanel control = this.createControl();
        JSplitPane content = new JSplitPane(0, control, splitPane);
        content.setContinuousLayout(true);
        content.setOneTouchExpandable(false);
        content.setDividerLocation(41);
        content.setDividerSize(5);
        this.add((Component)content, "Center");
        this.setBackground(Color.white);
        this.clientName = PanelName + clientName;
        this.factory = new JsonSocketFactory();
        this.recvItem.setLogFileName("client_" + clientName);
        this.sendItem.setRecvItem(this.recvItem);
        ServerTimeTickManager.getInstance().addListener(this);
    }

    private JPanel createControl() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.setMinimumSize(new Dimension(0, 0));
        Box box = UiFactory.createHorizontalBox();
        this.ipInfo = UiFactory.createTextBox(150);
        this.ipInfo.setText("127.0.0.1");
        this.ipInfo.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (JPanelClient.this.currentStatus || JPanelClient.this.currentClient == null) {
                    return;
                }
                JPanelClient.this.factory.removeClient("Client");
                JPanelClient.this.factory.clearHandler("Client");
                JPanelClient.this.currentClient.setAutoConnect(false);
                JPanelClient.this.currentClient = null;
            }
        });
        box.add(UiFactory.createPanel("IP\uff1a", this.ipInfo));
        this.portInfo = UiFactory.createSpinner(80, 6666, 1, 100000, 1);
        this.portInfo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JPanelClient.this.currentStatus || JPanelClient.this.currentClient == null) {
                    return;
                }
                JPanelClient.this.factory.removeClient("Client");
                JPanelClient.this.factory.clearHandler("Client");
                JPanelClient.this.currentClient.setAutoConnect(false);
                JPanelClient.this.currentClient = null;
            }
        });
        box.add(UiFactory.createPanel("\u7aef\u53e3\uff1a", this.portInfo));
        ArrayList<ComBoxItemBean> dataList = new ArrayList<ComBoxItemBean>();
        dataList.add(new ComBoxItemBean("0", "\u65e0\u957f\u5ea6\u4f4d"));
        dataList.add(new ComBoxItemBean("2", "2\u957f\u5ea6\u4f4d"));
        dataList.add(new ComBoxItemBean("4", "4\u957f\u5ea6\u4f4d"));
        this.pcbHeaderSize = UiFactory.createComboBox(100, dataList, e -> {
            ComBoxItemBean bean;
            String value;
            if (!this.currentStatus && this.currentClient != null) {
                this.factory.removeClient("Client");
                this.factory.clearHandler("Client");
                this.currentClient = null;
            }
            if ((value = (bean = (ComBoxItemBean)this.pcbHeaderSize.getSelectedItem()).getKey()).equals("0")) {
                this.recvItem.enableHeaderSize(false);
                this.sendItem.enableHeaderSize(false);
            } else {
                this.recvItem.enableHeaderSize(true);
                this.sendItem.enableHeaderSize(true);
            }
        });
        box.add(UiFactory.createPanel(" ", this.pcbHeaderSize));
        controlPanel.add(box);
        box = UiFactory.createHorizontalBox();
        box.setAlignmentX(0.5f);
        this.cbIsConnAlways = UiFactory.createCheckBox("\u81ea\u52a8\u91cd\u8fde", e -> {
            this.connAlways = this.cbIsConnAlways.isSelected();
            if (!this.currentStatus && this.currentClient != null) {
                this.currentClient.setAutoConnect(this.connAlways);
            }
        });
        box.add(this.cbIsConnAlways);
        controlPanel.add(box);
        box = UiFactory.createHorizontalBox();
        box.add(Box.createRigidArea(UiFactory.HGAP5));
        this.btnLink = UiFactory.createButton("\u8fde\u63a5", new BtnLinkClickListener());
        box.add(UiFactory.createPanel(this.btnLink, 100, 30));
        box.add(Box.createRigidArea(UiFactory.HGAP5));
        controlPanel.add(box);
        controlPanel.add(Box.createHorizontalGlue());
        return controlPanel;
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.shutdown();
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void OnServerTimeTickEvent() {
        if (this.currentClient == null) {
            return;
        }
        if (this.currentClient.isConnected()) {
            if (this.currentStatus) {
                return;
            }
            this.btnLink.setText("\u65ad\u5f00");
            this.tryConnection = false;
            this.recvItem.WriteMessage("\u5df2\u8fde\u63a5\u5230\u670d\u52a1\u5668");
            this.currentStatus = true;
            this.ipInfo.setEnabled(false);
            this.portInfo.setEnabled(false);
            this.pcbHeaderSize.setEnabled(false);
            this.cbIsConnAlways.setEnabled(false);
        } else {
            if (!this.currentStatus) {
                return;
            }
            this.btnLink.setText("\u8fde\u63a5");
            this.tryConnection = true;
            this.recvItem.WriteMessage("\u5df2\u65ad\u5f00\u8fde\u63a5", Color.red);
            this.currentStatus = false;
            this.ipInfo.setEnabled(true);
            this.portInfo.setEnabled(true);
            this.pcbHeaderSize.setEnabled(true);
            this.cbIsConnAlways.setEnabled(true);
        }
    }

    private void shutdown() {
        this.factory.removeClient("Client");
        this.factory.clearHandler("Client");
        if (this.currentClient != null) {
            this.currentClient.setAutoConnect(false);
            if (this.currentClient instanceof JsonContentClient) {
                ((JsonContentClient)this.currentClient).close();
            }
            this.currentClient = null;
        }
    }

    private class BtnLinkClickListener
    implements ActionListener {
        private BtnLinkClickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JPanelClient.this.uLock) {
                UiFactory.createMessageDialog("\u63d0\u793a", "\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\uff0c \u8bf7\u7a0d\u540e\uff01", 2);
                return;
            }
            JPanelClient.this.uLock = true;
            if (JPanelClient.this.currentClient == null) {
                String ip = JPanelClient.this.ipInfo.getText();
                String port = JPanelClient.this.portInfo.getValue().toString();
                if (StringUtil.isNull(ip).booleanValue() || StringUtil.isNull(port).booleanValue()) {
                    JPanelClient.this.uLock = false;
                    UiFactory.createMessageDialog("\u9519\u8bef", "IP\u5730\u5740\u548c\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", 0);
                    return;
                }
                if (!Pattern.matches("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$", ip.trim())) {
                    JPanelClient.this.uLock = false;
                    UiFactory.createMessageDialog("\u9519\u8bef", "\u8bf7\u8f93\u5165\u6709\u6548\u7684IP\u5730\u5740\uff01", 0);
                    return;
                }
                if (!StringUtil.isNumber(port)) {
                    JPanelClient.this.uLock = false;
                    UiFactory.createMessageDialog("\u9519\u8bef", "\u7aef\u53e3\u5fc5\u987b\u4e3a\u6570\u5b57\uff01", 0);
                    return;
                }
                if (port.length() < 1 || port.length() > 5) {
                    JPanelClient.this.uLock = false;
                    UiFactory.createMessageDialog("\u9519\u8bef", "\u7aef\u53e3\u8303\u56f4\u4e3a1-99999\uff01", 0);
                    return;
                }
                ComBoxItemBean bean = (ComBoxItemBean)JPanelClient.this.pcbHeaderSize.getSelectedItem();
                String headerSize = bean.getKey();
                int size = StringUtil.isNull(headerSize) != false ? 0 : (!StringUtil.isNumber(headerSize) ? 0 : Integer.parseInt(headerSize));
                JPanelClient.this.currentClient = JPanelClient.this.factory.createClient("Client", ip, Integer.parseInt(port), JPanelClient.this.connAlways, size);
                JPanelClient.this.factory.addHandler("ClientEvent", new JsonMessageHandler());
                JPanelClient.this.sendItem.setChannels(JPanelClient.this.factory.getClients());
                JPanelClient.this.uLock = false;
                return;
            }
            if (JPanelClient.this.tryConnection) {
                JPanelClient.this.currentClient.setAutoConnect(JPanelClient.this.connAlways);
                JPanelClient.this.currentClient.create();
            } else {
                JPanelClient.this.currentClient.setAutoConnect(false);
                JPanelClient.this.currentClient.shutDown();
            }
            JPanelClient.this.uLock = false;
        }
    }

    public class JsonMessageHandler
    implements OnReceivedEvent {
        @Override
        public void messageReceived(Object sender, Channel channel, String message, Object content) {
            boolean callbackFlag = false;
            String callbackContent = JPanelClient.this.recvItem.doAutoCallback((byte[])content);
            if (!StringUtil.isNull(callbackContent).booleanValue() && sender instanceof NetClientManager) {
                NetClientManager manager = (NetClientManager)sender;
                boolean isHexSend = JPanelClient.this.sendItem.getIsHex();
                if (isHexSend) {
                    manager.send(StringUtil.stringToByteArray(callbackContent), false);
                } else {
                    manager.send(callbackContent, false);
                }
                callbackFlag = true;
            }
            JPanelClient.this.recvItem.doJsonMessageHandler((byte[])content, channel);
            if (!callbackFlag) {
                return;
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception manager) {
                // empty catch block
            }
            String info = "A-[" + StringUtil.getDateNow("HH:mm:ss") + "] --> " + callbackContent;
            JPanelClient.this.recvItem.WriteMessage(info, Color.red);
        }
    }
}

