/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.main.manager;

import com.simba.business.ServerTimeTickManager;
import com.simba.common.log.LogHelper;
import com.simba.views.main.manager.ApplicationParams;
import java.io.File;

public class ApplicationManager {
    public static void init() {
        ApplicationManager.initRootLogger();
        ServerTimeTickManager.getInstance().init();
    }

    private static void initRootLogger() {
        File fp = new File(ApplicationParams.LOG_PATH);
        if (fp.exists()) {
            boolean canWrite = fp.canWrite();
            if (!canWrite) {
                System.out.println("Fatal Error: Log path: " + ApplicationParams.LOG_PATH + " can't write");
                System.exit(5000);
            }
        } else if (!fp.mkdir()) {
            System.out.println("Fatal Error: Data path: " + ApplicationParams.LOG_PATH + " can't create");
            System.exit(5000);
        }
        String accessLogPath = ApplicationParams.LOG_PATH + ApplicationParams.PATH_SEP + ApplicationParams.ACCESS_LOG;
        String errorLogPath = ApplicationParams.LOG_PATH + ApplicationParams.PATH_SEP + ApplicationParams.ERROR_LOG;
        String verboseLogPath = ApplicationParams.LOG_PATH + ApplicationParams.PATH_SEP + ApplicationParams.VERBOSE_LOG;
        try {
            LogHelper.configureRootLog(ApplicationParams.LOG_MODE, verboseLogPath, accessLogPath, errorLogPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

