/*
 * Decompiled with CFR 0.152.
 */
package com.simba.views.main;

import com.simba.common.utils.Utilities;
import com.simba.views.main.InternalFrame;
import com.simba.views.main.manager.ApplicationManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.jb2011.lnf.beautyeye.BeautyEyeLNFHelper;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class Main
extends SingleFrameApplication {
    public static final String CONTROL_VERY_LIGHT_SHADOW_KEY = "controlVeryLightShadowColor";
    public static final String CONTROL_LIGHT_SHADOW_KEY = "controlLightShadowColor";
    public static final String CONTROL_MID_SHADOW_KEY = "controlMidShadowColor";
    public static final String CONTROL_VERY_DARK_SHADOW_KEY = "controlVeryDarkShadowColor";
    public static final String CONTROL_DARK_SHADOW_KEY = "controlDarkShadowColor";
    public static final String TITLE_GRADIENT_COLOR1_KEY = "titleGradientColor1";
    public static final String TITLE_GRADIENT_COLOR2_KEY = "titleGradientColor2";
    public static final String TITLE_FOREGROUND_KEY = "titleForegroundColor";
    public static final String CODE_HIGHLIGHT_KEY = "codeHighlightColor";
    public static final String TITLE_FONT_KEY = "titleFont";
    public static final String SUB_PANEL_BACKGROUND_KEY = "subPanelBackgroundColor";
    private JPanel mainPanel;
    private InternalFrame container;
    private ResourceMap resourceMap;

    @Override
    protected void initialize(String[] args) {
        try {
            ApplicationManager.init();
            BeautyEyeLNFHelper.launchBeautyEyeLNF();
            UIManager.put("RootPane.setupButtonVisible", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resourceMap = this.getContext().getResourceMap();
    }

    @Override
    protected void startup() {
        UIManager.addPropertyChangeListener(event -> {
            if (event.getPropertyName().equals("lookAndFeel")) {
                this.configureDefaults();
            }
        });
        this.configureDefaults();
        FrameView view = this.getMainView();
        view.setComponent(this.createMainPanel());
        view.setToolBar(this.createMenuBar());
        this.getMainFrame().setIconImage(this.resourceMap.getImageIcon("Application.icon").getImage());
        this.show(view);
    }

    public static void main(String[] args) {
        Main.launch(Main.class, args);
    }

    private void configureDefaults() {
        Color controlColor = UIManager.getColor("control");
        UIManager.put(CONTROL_VERY_LIGHT_SHADOW_KEY, Utilities.deriveColorHSB(controlColor, 0.0f, 0.0f, -0.02f));
        UIManager.put(CONTROL_LIGHT_SHADOW_KEY, Utilities.deriveColorHSB(controlColor, 0.0f, 0.0f, -0.06f));
        UIManager.put(CONTROL_MID_SHADOW_KEY, Utilities.deriveColorHSB(controlColor, 0.0f, 0.0f, -0.16f));
        UIManager.put(CONTROL_VERY_DARK_SHADOW_KEY, Utilities.deriveColorHSB(controlColor, 0.0f, 0.0f, -0.5f));
        UIManager.put(CONTROL_DARK_SHADOW_KEY, Utilities.deriveColorHSB(controlColor, 0.0f, 0.0f, -0.32f));
        Color titleColor = UIManager.getColor(Main.usingNimbus() ? "nimbusBase" : "activeCaption");
        if (titleColor == null) {
            titleColor = controlColor;
        }
        float[] hsb = Color.RGBtoHSB(titleColor.getRed(), titleColor.getGreen(), titleColor.getBlue(), null);
        UIManager.put(TITLE_GRADIENT_COLOR1_KEY, Color.getHSBColor(hsb[0] - 0.013f, 0.15f, 0.85f));
        UIManager.put(TITLE_GRADIENT_COLOR2_KEY, Color.getHSBColor(hsb[0] - 0.005f, 0.24f, 0.8f));
        UIManager.put(TITLE_FOREGROUND_KEY, Color.getHSBColor(hsb[0], 0.54f, 0.4f));
        UIManager.put(CODE_HIGHLIGHT_KEY, Color.getHSBColor(hsb[0] - 0.005f, 0.2f, 0.95f));
        Font labelFont = UIManager.getFont("Label.font");
        UIManager.put(TITLE_FONT_KEY, labelFont.deriveFont(1, (float)labelFont.getSize() + 4.0f));
        Color panelColor = UIManager.getColor("Panel.background");
        UIManager.put(SUB_PANEL_BACKGROUND_KEY, Utilities.deriveColorHSB(panelColor, 0.0f, 0.0f, -0.06f));
    }

    public static boolean usingNimbus() {
        return UIManager.getLookAndFeel().getName().equals("Nimbus");
    }

    protected JComponent createMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.container = new InternalFrame();
        this.mainPanel.add((Component)this.container, "Center");
        return this.mainPanel;
    }

    protected JToolBar createMenuBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setName("toolBar");
        JButton serverMenu = new JButton("\u670d\u52a1\u7aef");
        serverMenu.setName("menuServer");
        serverMenu.setMargin(new Insets(2, 10, 2, 10));
        serverMenu.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.container.createServerFrame("\u670d\u52a1\u7aef", InternalFrame.DEMO_FRAME_LAYER, 900, 720);
            }
        });
        toolBar.add(serverMenu);
        JButton clientMenu = new JButton("\u5ba2\u6237\u7aef");
        clientMenu.setName("menuClient");
        clientMenu.setMargin(new Insets(2, 10, 2, 10));
        clientMenu.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.container.createClientFrame("\u5ba2\u6237\u7aef", InternalFrame.DEMO_FRAME_LAYER, 900, 720);
            }
        });
        toolBar.add(clientMenu);
        return toolBar;
    }

    static {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        System.setProperty("sun.java2d.noddraw", "true");
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafInfo.length; ++i) {
            if (!lafInfo[i].getName().equals("Nimbus")) continue;
            lafInfo[i] = new UIManager.LookAndFeelInfo("Nimbus", "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            break;
        }
        UIManager.setInstalledLookAndFeels(lafInfo);
        UIManager.put("swing.boldMetal", Boolean.FALSE);
    }
}

