/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.server.tools;

import com.simba.common.log.LogManager;
import com.simba.net.base.NetChannel;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class JsonServerClient
extends NetChannel {
    private String id;
    private String serverIp;
    private int serverPort;
    private Channel channel;
    protected static final Logger logger = Logger.getLogger(JsonServerClient.class);

    public JsonServerClient(Channel channel) {
        this.channel = channel;
        try {
            SocketAddress point = channel.getRemoteAddress();
            InetSocketAddress ipPoint = (InetSocketAddress)point;
            Inet4Address ip = (Inet4Address)ipPoint.getAddress();
            this.serverIp = ip.toString();
            this.serverPort = ipPoint.getPort();
            this.id = String.valueOf(channel.getId().shortValue());
        }
        catch (Exception e) {
            this.serverIp = "0.0.0.0";
            this.serverPort = 0;
        }
    }

    public String isConnectText() {
        return this.isConnected() ? "\u5df2\u8fde\u63a5" : "\u65ad\u5f00";
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    @Override
    public void init() {
    }

    @Override
    public void create() {
    }

    @Override
    public void shutDown() {
        if (!this.isConnected()) {
            return;
        }
        this.channel.close();
    }

    @Override
    public void sendByteContent(byte[] content) {
        if (content == null || content.length <= 0) {
            return;
        }
        if (!this.isConnected()) {
            LogManager.LogError(logger, "Socket is not connect, SendRequest error");
            return;
        }
        try {
            this.CommitResponse(content, false);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "SCK\u53d1\u9001\u8bf7\u6c42\u65f6\u6355\u83b7\u5f02\u5e38:" + ex.getMessage());
        }
    }

    @Override
    public void sendJsonContent(String content) {
        if (content == null || content.length() <= 0) {
            return;
        }
        if (!this.isConnected()) {
            LogManager.LogError(logger, "Socket is not connect, SendRequest error");
            return;
        }
        try {
            this.CommitResponse(content, false);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "SCK\u53d1\u9001\u8bf7\u6c42\u65f6\u6355\u83b7\u5f02\u5e38:" + ex.getMessage());
        }
    }

    public void CommitResponse(String content, boolean needClose) {
        byte[] contentBuffer = content.getBytes();
        this.CommitResponse(contentBuffer, needClose);
    }

    public void CommitResponse(byte[] content, boolean needClose) {
        try {
            if (this.channel == null || content == null) {
                return;
            }
            int limit = content.length;
            ByteBuffer returnBuffer = ByteBuffer.allocate(limit);
            returnBuffer.put(content, 0, limit);
            returnBuffer.rewind();
            ChannelBuffer duplicateBuffer = ChannelBuffers.wrappedBuffer(returnBuffer);
            ChannelFuture writeFuture = this.channel.write(duplicateBuffer);
            if (needClose) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Send Error : " + ex.getMessage());
        }
    }

    @Override
    public void setAutoConnect(boolean flag) {
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getId() {
        return this.id;
    }
}

