/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.server.tools;

import com.simba.net.base.NetChannel;
import com.simba.net.base.events.OnActiveEvent;
import com.simba.net.base.events.OnInActiveEvent;
import com.simba.net.base.events.OnReceivedEvent;
import com.simba.net.server.NetServerManager;
import java.util.Map;

public class JsonContentServer {
    private int headerSize;
    private int serverPort;
    private NetServerManager netServer;

    public int getServerPort() {
        return this.serverPort;
    }

    public JsonContentServer(int port, int headerSize) {
        this.serverPort = port;
        this.headerSize = headerSize;
        this.init();
        this.create();
    }

    public Map<String, NetChannel> getClients() {
        if (this.netServer != null) {
            return this.netServer.getChannels();
        }
        return null;
    }

    public void init() {
        this.netServer = new NetServerManager();
    }

    public boolean isConnected() {
        return this.netServer != null && this.netServer.isConnected();
    }

    public void create() {
        if (this.isConnected()) {
            return;
        }
        if (this.netServer != null) {
            this.netServer.createServer(this.serverPort, this.headerSize);
        }
    }

    public void shutDown() {
        if (!this.isConnected()) {
            return;
        }
        if (this.netServer == null) {
            return;
        }
        for (NetChannel channel : this.netServer.getChannels().values()) {
            channel.shutDown();
        }
        this.netServer.shutDown();
    }

    public void addReceivedEvent(OnReceivedEvent event) {
        this.netServer.addReceivedEvent(event);
    }

    public void addActiveEvent(OnActiveEvent event) {
        this.netServer.addActiveEvent(event);
    }

    public void addInActiveEvent(OnInActiveEvent event) {
        this.netServer.addInActiveEvent(event);
    }
}

