/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.server;

import com.simba.common.log.LogManager;
import com.simba.common.thread.NamedThreadFactory;
import com.simba.net.base.NetChannel;
import com.simba.net.base.events.OnActiveEvent;
import com.simba.net.base.events.OnInActiveEvent;
import com.simba.net.base.events.OnReceivedEvent;
import com.simba.net.server.NetServerHandler;
import com.simba.net.server.factory.ServerPipelineFactory;
import com.simba.net.server.tools.JsonServerClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class NetServerManager {
    protected static final Logger logger = Logger.getLogger(NetServerManager.class);
    private List<OnReceivedEvent> receivedEvents = new ArrayList<OnReceivedEvent>();
    private List<OnActiveEvent> activeEvents = new ArrayList<OnActiveEvent>();
    private List<OnInActiveEvent> inActiveEvents = new ArrayList<OnInActiveEvent>();
    private Channel boundChannel;
    private int bindPort;
    private Map<String, NetChannel> clientsDict = new HashMap<String, NetChannel>();
    public String serverAddress;
    public int serverPort;
    private ExecutorService executor;
    private int ioThreads = Runtime.getRuntime().availableProcessors();
    protected ServerBootstrap bootstrap;
    protected ExecutorService eventExecutor;

    public boolean isConnected() {
        if (this.boundChannel == null) {
            return false;
        }
        return this.boundChannel.isOpen();
    }

    public void createServer(int port, int headerSize) {
        if (port < 1) {
            return;
        }
        this.bindPort = port;
        this.serverPort = port;
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
        this.executor.submit(() -> this.startServer(headerSize));
    }

    public void shutDown() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
        this.executor.submit(this::doShutDown);
    }

    private void startServer(int headerSize) {
        this.runServer(headerSize);
        LogManager.LogInfo(logger, "Start Frame Serve Bind To [" + this.bindPort + "] Successful");
    }

    private void doShutDown() {
        this.CloseServer();
    }

    private void runServer(int headerSize) {
        try {
            this.checkPortBound();
            ExecutorService bossExecutor = Executors.newCachedThreadPool();
            MemoryAwareThreadPoolExecutor workerExecutor = new MemoryAwareThreadPoolExecutor(this.ioThreads, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("worker thread "));
            int eventThreads = 16;
            if (this.eventExecutor == null) {
                this.eventExecutor = new OrderedMemoryAwareThreadPoolExecutor(eventThreads, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("event thread "));
            }
            this.bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory((Executor)bossExecutor, workerExecutor, this.ioThreads));
            this.bootstrap.setPipelineFactory(new ServerPipelineFactory(headerSize, this.eventExecutor, new NetServerHandler(this)));
            this.bootstrap.setOption("reuseAddress", true);
            this.bootstrap.setOption("child.reuseAddress", true);
            this.bootstrap.setOption("writeBufferHighWaterMark", 65536);
            this.bootstrap.setOption("writeBufferLowWaterMark", 32768);
            this.bootstrap.setOption("child.tcpNoDelay", true);
            this.bootstrap.setOption("child.sendBufferSize", 65536);
            this.bootstrap.setOption("child.receiveBufferSize", 65536);
            InetSocketAddress inetSocketAddress = new InetSocketAddress("0.0.0.0", this.bindPort);
            this.boundChannel = this.bootstrap.bind(inetSocketAddress);
        }
        catch (Exception ex) {
            LogManager.LogInfo(logger, "Catch an Exception : " + ex.getMessage());
        }
    }

    private void CloseServer() {
        try {
            this.boundChannel.close();
            this.boundChannel = null;
        }
        catch (Exception ex) {
            LogManager.LogInfo(logger, "Catch an Exception : " + ex.getMessage());
        }
        finally {
            if (this.bootstrap != null) {
                this.bootstrap.releaseExternalResources();
                this.bootstrap.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPortBound() throws IOException {
        boolean result;
        String message = "";
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(this.getServerPort(), 100, InetAddress.getByName("0.0.0.0"));
            result = false;
        }
        catch (Exception e) {
            message = e.getMessage();
            result = true;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (result) {
            throw new IOException(message);
        }
    }

    public Map<String, NetChannel> getChannels() {
        return this.clientsDict;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void addReceivedEvent(OnReceivedEvent event) {
        this.receivedEvents.add(event);
    }

    public void addActiveEvent(OnActiveEvent event) {
        this.activeEvents.add(event);
    }

    public void addInActiveEvent(OnInActiveEvent event) {
        this.inActiveEvents.add(event);
    }

    public void onChannelActive(Channel channel) {
        String channelId = String.valueOf(channel.getId().shortValue());
        this.clientsDict.remove(channelId);
        JsonServerClient client = new JsonServerClient(channel);
        this.clientsDict.put(channelId, client);
        LogManager.LogInfo(logger, "Channel-[" + channelId + "] Connected.");
        String message = "Channel-" + channelId + "active";
        for (OnActiveEvent event : this.activeEvents) {
            event.onConnectionOpen(channel, message);
        }
    }

    public void onChannelInactive(Channel channel) {
        String channelId = String.valueOf(channel.getId().shortValue());
        this.clientsDict.remove(channelId);
        LogManager.LogInfo(logger, "Channel-[" + channelId + "] Disconnected.");
        String message = "Channel-" + channelId + "inactive";
        for (OnInActiveEvent event : this.inActiveEvents) {
            event.onConnectionClosed(channel, message);
        }
    }

    public void onChannelMessage(Channel channel, Object content) {
        String channelId = String.valueOf(channel.getId().shortValue());
        if (content instanceof byte[]) {
            String text = new String((byte[])content, StandardCharsets.UTF_8);
            LogManager.LogInfo(logger, "Channel-[" + channelId + "] Read Bytes-[" + text + "]");
            String message = "Channel-" + channelId + "receive message";
            for (OnReceivedEvent event : this.receivedEvents) {
                event.messageReceived(this, channel, message, content);
            }
        }
    }

    public void onChannelException(Channel channel, Throwable exception) {
        LogManager.LogDebug(logger, "Catch an exception : " + exception.getMessage());
    }
}

