/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.server;

import com.simba.common.log.LogManager;
import com.simba.net.server.NetServerManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class NetServerHandler
extends IdleStateAwareChannelHandler {
    protected static final Logger logger = Logger.getLogger(NetServerHandler.class);
    private NetServerManager server;

    public NetServerHandler(NetServerManager server) {
        this.server = server;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            Channel channel = ctx.getChannel();
            this.server.onChannelActive(channel);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            Channel channel = ctx.getChannel();
            this.server.onChannelInactive(channel);
            channel.close();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        try {
            Channel channel = ctx.getChannel();
            this.server.onChannelException(channel, e.getCause());
            if (channel != null) {
                channel.close();
            } else {
                e.getChannel().close();
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            Channel channel = ctx.getChannel();
            this.server.onChannelMessage(channel, e.getMessage());
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
    }
}

