/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.client.tools;

import com.simba.common.log.LogManager;
import com.simba.net.base.NetChannel;
import com.simba.net.base.events.OnReceivedEvent;
import com.simba.net.client.tools.JsonContentClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JsonSocketFactory {
    private Map<String, NetChannel> clients = new HashMap<String, NetChannel>();
    private Map<String, Map<String, OnReceivedEvent>> jsonMessageEvents = new HashMap<String, Map<String, OnReceivedEvent>>();
    private static final Logger logger = Logger.getLogger(JsonSocketFactory.class);

    public NetChannel createClient(String key, String ip, int port, boolean connAlways, int headerSize) {
        if (this.clients.containsKey(key)) {
            return this.clients.get(key);
        }
        JsonContentClient client = new JsonContentClient(ip, port, connAlways, headerSize);
        if (this.jsonMessageEvents.containsKey(key)) {
            for (OnReceivedEvent handler : this.jsonMessageEvents.get(key).values()) {
                client.addReceiveEvent(handler);
            }
        }
        this.clients.put(key, client);
        return client;
    }

    public Map<String, NetChannel> getClients() {
        return this.clients;
    }

    public NetChannel getClient(String key) {
        if (this.clients.containsKey(key)) {
            return this.clients.get(key);
        }
        return null;
    }

    public void removeClient(String key) {
        if (this.clients.containsKey(key)) {
            this.clients.get(key).shutDown();
            this.clients.remove(key);
        }
    }

    public void shutDown() {
        for (NetChannel client : this.clients.values()) {
            client.shutDown();
        }
        this.clients.clear();
    }

    private void addJsonEventToMap(String key, String handleName, OnReceivedEvent handler) {
        Map<String, OnReceivedEvent> handlers;
        NetChannel client = this.clients.get(key);
        if (!(client instanceof JsonContentClient)) {
            return;
        }
        if (!this.jsonMessageEvents.containsKey(key)) {
            this.jsonMessageEvents.put(key, new HashMap());
        }
        if ((handlers = this.jsonMessageEvents.get(key)).containsKey(handleName)) {
            LogManager.LogError(logger, "\u53d1\u73b0\u91cd\u590dHandleName");
            return;
        }
        this.jsonMessageEvents.get(key).put(handleName, handler);
        ((JsonContentClient)client).addReceiveEvent(handler);
    }

    public void addHandler(String handleName, OnReceivedEvent handler) {
        for (String key : this.clients.keySet()) {
            this.addJsonEventToMap(key, handleName, handler);
        }
    }

    public void addHandler(String key, String handleName, OnReceivedEvent handler) {
        if (!this.clients.containsKey(key)) {
            return;
        }
        this.addJsonEventToMap(key, handleName, handler);
    }

    public void clearHandler() {
        for (String key : this.jsonMessageEvents.keySet()) {
            this.jsonMessageEvents.get(key).clear();
        }
    }

    public void clearHandler(String key) {
        if (this.jsonMessageEvents.containsKey(key)) {
            this.jsonMessageEvents.get(key).clear();
        }
    }
}

