/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.client.tools;

import com.simba.net.base.NetChannel;
import com.simba.net.client.tools.JsonSocketFactory;
import java.util.Map;
import org.apache.log4j.Logger;

public class JsonContentTools {
    private static final Logger logger = Logger.getLogger(JsonContentTools.class);

    public static JsonContentTools getInstance() {
        return JsonContentToolsHolder.INSTANCE;
    }

    private JsonContentTools() {
    }

    public void sendMessage(JsonSocketFactory factory, String message) {
        Map<String, NetChannel> clients = factory.getClients();
        for (NetChannel client : clients.values()) {
            client.sendJsonContent(message);
        }
    }

    public void sendMessage(JsonSocketFactory factory, String key, String message) {
        NetChannel client = factory.getClient(key);
        if (client != null) {
            client.sendJsonContent(message);
        }
    }

    public void sendMessage(NetChannel client, String message) {
        if (client != null) {
            client.sendJsonContent(message);
        }
    }

    private static class JsonContentToolsHolder {
        private static final JsonContentTools INSTANCE = new JsonContentTools();

        private JsonContentToolsHolder() {
        }
    }
}

