/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.client.tools;

import com.simba.business.ServerTimeTickManager;
import com.simba.common.log.LogManager;
import com.simba.common.utils.StringUtil;
import com.simba.net.base.NetChannel;
import com.simba.net.base.events.OnActiveEvent;
import com.simba.net.base.events.OnInActiveEvent;
import com.simba.net.base.events.OnReceivedEvent;
import com.simba.net.client.NetClientManager;
import org.apache.log4j.Logger;

public class JsonContentClient
extends NetChannel {
    private String serverIp;
    private int serverPort;
    private boolean connAlways;
    private int headerSize;
    private final Object clientLock = new Object();
    private NetClientManager netClient;
    protected static final Logger logger = Logger.getLogger(JsonContentClient.class);

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public JsonContentClient(String ip, int port, boolean connAlways, int headerSize) {
        this.serverIp = ip;
        this.serverPort = port;
        this.connAlways = connAlways;
        this.headerSize = headerSize;
        this.init();
        this.connectToServer();
        ServerTimeTickManager.getInstance().addListener(this::reConnect);
    }

    @Override
    public boolean isConnected() {
        return this.netClient != null && this.netClient.isConnected();
    }

    @Override
    public void init() {
        try {
            if (StringUtil.isNull(this.serverIp).booleanValue() || this.serverPort <= 0) {
                LogManager.LogError(logger, "\u3010JsonContentClient\u3011\uff1a Init Error: Invalid Address");
                return;
            }
            this.netClient = new NetClientManager(this.serverIp, this.serverPort);
            this.netClient.Init(this.headerSize);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "\u3010JsonContentClient\u3011\uff1a Init Error--ex \uff1a " + ex.getMessage());
        }
    }

    @Override
    public void create() {
        this.connectToServer();
    }

    @Override
    public void shutDown() {
        if (!this.isConnected()) {
            return;
        }
        if (this.netClient != null) {
            this.netClient.shutDown();
        }
    }

    public void close() {
        if (this.netClient != null) {
            this.netClient.close();
        }
    }

    @Override
    public void sendByteContent(byte[] content) {
        if (content == null || content.length <= 0) {
            return;
        }
        if (!this.isConnected()) {
            LogManager.LogError(logger, "Socket is not connect, SendRequest error");
            return;
        }
        try {
            this.netClient.send(content, false);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "SCK\u53d1\u9001\u8bf7\u6c42\u65f6\u6355\u83b7\u5f02\u5e38:" + ex.getMessage());
        }
    }

    @Override
    public void sendJsonContent(String content) {
        if (content == null || content.length() <= 0) {
            return;
        }
        if (!this.isConnected()) {
            LogManager.LogError(logger, "Socket is not connect, SendRequest error");
            return;
        }
        try {
            this.netClient.send(content, false);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "SCK\u53d1\u9001\u8bf7\u6c42\u65f6\u6355\u83b7\u5f02\u5e38:" + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoConnect(boolean flag) {
        Object object = this.clientLock;
        synchronized (object) {
            this.connAlways = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reConnect() {
        try {
            Object object = this.clientLock;
            synchronized (object) {
                if (this.connAlways && !this.isConnected()) {
                    LogManager.LogWarn(logger, "Server lost connection, try to reconnect.");
                    this.connectToServer();
                }
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    public void connectToServer() {
        if (this.isConnected()) {
            return;
        }
        if (this.netClient != null) {
            this.netClient.doConnect();
        }
    }

    public void addReceiveEvent(OnReceivedEvent handler) {
        if (this.netClient == null || handler == null) {
            return;
        }
        this.netClient.addReceivedEvent(handler);
    }

    public void addActiveEvent(OnActiveEvent handler) {
        if (this.netClient == null || handler == null) {
            return;
        }
        this.netClient.AddActiveEvent(handler);
    }

    public void addInActionEvent(OnInActiveEvent handler) {
        if (this.netClient == null || handler == null) {
            return;
        }
        this.netClient.AddInActiveEvent(handler);
    }
}

