/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.client.factory;

import com.simba.net.client.factory.ClientReadBytesDecoder;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class ClientPipelineFactory
implements ChannelPipelineFactory {
    protected static final int MAX_FRAME_LENGTH = 65535;
    private static final int LENGTH_FIELD_OFFSET = 0;
    protected final ExecutorService executor;
    protected final ChannelUpstreamHandler handler;
    private int headerSize;

    public ClientPipelineFactory(int headerSize, ExecutorService executor, ChannelUpstreamHandler handler) {
        this.headerSize = headerSize;
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.headerSize == 2 || this.headerSize == 4) {
            pipeline.addLast("frameLengthDecoder", new LengthFieldBasedFrameDecoder(65535, 0, this.headerSize, 0, this.headerSize));
            pipeline.addLast("frameEncoder", new LengthFieldPrepender(this.headerSize));
        }
        pipeline.addLast("bytesReadDecoder", new ClientReadBytesDecoder());
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        if (this.executor != null) {
            pipeline.addLast("executor", new ExecutionHandler(this.executor));
        }
        pipeline.addLast("handler", this.handler);
        return pipeline;
    }
}

