/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.client;

import com.simba.common.log.LogManager;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.net.base.events.OnActiveEvent;
import com.simba.net.base.events.OnInActiveEvent;
import com.simba.net.base.events.OnReceivedEvent;
import com.simba.net.client.NetClientHandler;
import com.simba.net.client.factory.ClientPipelineFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.timeout.IdleState;

public class NetClientManager {
    public static final int EVENT_THREAD_POOL_SIZE = 2;
    public static final int IO_THREAD_POOL_SIZE = 2;
    private Channel clientChannel;
    private String serverIp;
    private int serverPort;
    private ClientBootstrap bootstrap;
    private List<OnReceivedEvent> receivedEvents = new ArrayList<OnReceivedEvent>();
    private List<OnActiveEvent> activeEvents = new ArrayList<OnActiveEvent>();
    private List<OnInActiveEvent> inActiveEvents = new ArrayList<OnInActiveEvent>();
    private final AtomicBoolean doConnecting = new AtomicBoolean(false);
    protected static final Logger logger = Logger.getLogger(NetClientManager.class);

    public NetClientManager(String serverIp, int serverPort) {
        this.serverIp = serverIp;
        this.serverPort = serverPort;
    }

    public boolean isConnected() {
        return this.clientChannel != null && this.clientChannel.isConnected();
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void Init(int headerSize) {
        try {
            this.InitBootstrap(headerSize);
        }
        catch (Exception ex) {
            String info = "Catch an exception : " + ex.getMessage();
            LogManager.LogError(logger, info);
        }
    }

    private void InitBootstrap(int headerSize) {
        try {
            ExecutorService bossExecutor = Executors.newCachedThreadPool();
            MemoryAwareThreadPoolExecutor workerExecutor = new MemoryAwareThreadPoolExecutor(2, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new CounterThreadFactory("Socket Client Worker Thread "));
            OrderedMemoryAwareThreadPoolExecutor eventExecutor = new OrderedMemoryAwareThreadPoolExecutor(2, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new CounterThreadFactory("Socket Client Event Thread "));
            this.bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory((Executor)bossExecutor, workerExecutor, 2));
            this.bootstrap.setPipelineFactory(new ClientPipelineFactory(headerSize, eventExecutor, new NetClientHandler(this)));
            this.bootstrap.setOption("reuseAddress", true);
            this.bootstrap.setOption("child.reuseAddress", true);
            this.bootstrap.setOption("writeBufferHighWaterMark", 65536);
            this.bootstrap.setOption("writeBufferLowWaterMark", 32768);
            this.bootstrap.setOption("child.tcpNoDelay", true);
            this.bootstrap.setOption("child.keepAlive", true);
            this.bootstrap.setOption("child.sendBufferSize", 65536);
            this.bootstrap.setOption("child.receiveBufferSize", 65536);
        }
        catch (Exception ex) {
            String info = "Catch an exception : " + ex.getMessage();
            LogManager.LogError(logger, info);
        }
    }

    public void addReceivedEvent(OnReceivedEvent event) {
        this.receivedEvents.add(event);
    }

    public void AddActiveEvent(OnActiveEvent event) {
        this.activeEvents.add(event);
    }

    public void AddInActiveEvent(OnInActiveEvent event) {
        this.inActiveEvents.add(event);
    }

    public void channelExceptionCaught(Channel channel, Throwable cause) {
        LogManager.LogError(logger, "Catch an exception when receive message from netty client : exception--" + cause.toString());
    }

    public void channelIdleState(Channel channel, IdleState state) {
    }

    public void messageReceived(Channel channel, Object content) {
        try {
            short channelId = channel.getId().shortValue();
            String message = "Channel-" + channelId + "receive message";
            for (OnReceivedEvent event : this.receivedEvents) {
                event.messageReceived(this, channel, message, content);
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public void onChannelClosed(Channel channel) {
        try {
            short shortId = channel.getId().shortValue();
            String message = "Channel-[" + shortId + "] Disconnected";
            for (OnInActiveEvent event : this.inActiveEvents) {
                event.onConnectionClosed(channel, message);
            }
            LogManager.LogInfo(logger, message);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public void onChannelConnected(Channel channel) {
        try {
            short shortId = channel.getId().shortValue();
            this.clientChannel = channel;
            String message = "Channel-[" + shortId + "] Connected";
            for (OnActiveEvent event : this.activeEvents) {
                event.onConnectionOpen(channel, message);
            }
            LogManager.LogInfo(logger, message);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public void send(Object messageObj, Boolean close) {
        if (messageObj == null && !this.isConnected()) {
            LogManager.LogInfo(logger, "Channel Inactive Send Content-[" + messageObj + "]");
            return;
        }
        if (this.isConnected()) {
            byte[] message = messageObj instanceof String ? ((String)messageObj).getBytes() : (byte[])messageObj;
            this.doWrite(message, close);
            LogManager.LogInfo(logger, "Channel-[" + this.clientChannel.getId().shortValue() + "] Send Content-[" + messageObj + "]");
        }
    }

    protected boolean isNeedClose(Object response, boolean close) {
        return close;
    }

    public synchronized void doConnect() {
        try {
            if (this.isConnected() || this.doConnecting.get()) {
                return;
            }
            this.doConnecting.set(true);
            ChannelFuture chFuture = this.bootstrap.connect(new InetSocketAddress(this.serverIp, this.serverPort));
            chFuture.addListener(future -> {
                this.doConnecting.set(false);
                Channel ch = future.getChannel();
                if (ch != null && ch.isConnected()) {
                    ch.setAttachment(this);
                    LogManager.LogDebug(logger, "Create Net Client.");
                }
            });
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception when receive connect to channel : exception--" + ex.getMessage());
        }
    }

    public synchronized void disconnect() {
        if (this.clientChannel != null) {
            this.clientChannel.disconnect();
            this.clientChannel = null;
            LogManager.LogDebug(logger, "Close Net Client.");
        }
    }

    private ChannelFuture doWrite(Object contentObj, Boolean close) {
        try {
            if (!(contentObj instanceof byte[])) {
                return null;
            }
            byte[] content = (byte[])contentObj;
            int limit = content.length;
            ByteBuffer returnBuffer = ByteBuffer.allocate(limit);
            returnBuffer.put(content, 0, limit);
            returnBuffer.rewind();
            ChannelBuffer duplicateBuffer = ChannelBuffers.wrappedBuffer(returnBuffer);
            ChannelFuture writeFuture = this.clientChannel.write(duplicateBuffer);
            if (this.isNeedClose(contentObj, close)) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
            return writeFuture;
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            return null;
        }
    }

    public void shutDown() {
        try {
            this.disconnect();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public void close() {
        this.bootstrap.shutdown();
    }
}

