/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.client;

import com.simba.common.log.LogManager;
import com.simba.net.client.NetClientManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class NetClientHandler
extends IdleStateAwareChannelHandler {
    protected static final Logger logger = Logger.getLogger(NetClientHandler.class);
    private NetClientManager _manager;

    public NetClientHandler(NetClientManager manager) {
        this._manager = manager;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            if (this._manager == null) {
                return;
            }
            Channel channel = ctx.getChannel();
            this._manager.onChannelConnected(channel);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            if (this._manager == null) {
                return;
            }
            Channel channel = ctx.getChannel();
            this._manager.onChannelClosed(channel);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        try {
            if (this._manager == null) {
                return;
            }
            Channel channel = ctx.getChannel();
            this._manager.channelIdleState(channel, e.getState());
            channel.close();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        try {
            if (this._manager == null) {
                return;
            }
            Channel channel = ctx.getChannel();
            this._manager.channelExceptionCaught(channel, e.getCause());
            channel.close();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            if (this._manager == null) {
                return;
            }
            Channel channel = ctx.getChannel();
            this._manager.messageReceived(channel, e.getMessage());
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception : " + ex.getMessage());
        }
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
    }
}

