/*
 * Decompiled with CFR 0.152.
 */
package com.simba.net.base;

import com.simba.common.utils.FrameUtils;
import com.simba.net.base.PropertyChangedEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class NetChannel {
    private List<PropertyChangedEvent> propertyChangedEvents = new ArrayList<PropertyChangedEvent>();
    private boolean isSelected = true;

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
        for (PropertyChangedEvent event : this.propertyChangedEvents) {
            event.OnPropertyChanged("isSelected");
        }
    }

    public void sendContentWithLength(byte[] sendBuffer, int length) {
        byte[] content;
        if (sendBuffer == null || sendBuffer.length <= 0) {
            return;
        }
        if (length == 4) {
            int sendBufferLen = sendBuffer.length;
            byte[] lenBuffer = new byte[length];
            FrameUtils.getInstance().setIntBigEndian(0, sendBufferLen, lenBuffer);
            content = new byte[sendBufferLen + 4];
            System.arraycopy(lenBuffer, 0, content, 0, 4);
            System.arraycopy(sendBuffer, 0, content, 4, sendBufferLen);
        } else if (length == 2) {
            int sendBufferLen = sendBuffer.length;
            byte[] lenBuffer = new byte[length];
            FrameUtils.getInstance().setShortBigEndian(0, sendBufferLen, lenBuffer);
            content = new byte[sendBufferLen + 2];
            System.arraycopy(lenBuffer, 0, content, 0, 2);
            System.arraycopy(sendBuffer, 0, content, 2, sendBufferLen);
        } else if (length == 0) {
            content = sendBuffer;
        } else {
            return;
        }
        this.sendByteContent(content);
    }

    public abstract boolean isConnected();

    public abstract void init();

    public abstract void create();

    public abstract void shutDown();

    public abstract void sendByteContent(byte[] var1);

    public abstract void sendJsonContent(String var1);

    public abstract void setAutoConnect(boolean var1);
}

