/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Map<String, SimpleDateFormat> formats = new HashMap<String, SimpleDateFormat>();
    private static Random random = new Random();

    public static String byteToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase()).append(" ");
        }
        return sb.toString();
    }

    public static Boolean isNotNull(String str) {
        return str != null && !str.equals("");
    }

    public static Boolean isNull(String str) {
        return str == null || str.equals("");
    }

    public static String getDateNow() {
        String key = "yyyy-MM-dd HH:mm:ss";
        return StringUtil.getDateNow(key);
    }

    public static String getDateNow(String formatStr) {
        SimpleDateFormat format;
        if (formats.containsKey(formatStr)) {
            format = formats.get(formatStr);
        } else {
            format = new SimpleDateFormat(formatStr);
            formats.put(formatStr, format);
        }
        return format.format(new Date());
    }

    public static String formatZero(String str, int digit) {
        int strLen = str.length();
        int zeroLen = digit - strLen;
        if (zeroLen < 0) {
            return "0000";
        }
        String zero = "";
        for (int i = 0; i < zeroLen; ++i) {
            zero = zero + "0";
        }
        return zero + str;
    }

    public static long getTimeDifference(Date beginTime, Date endTime) {
        try {
            return endTime.getTime() - beginTime.getTime();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static boolean isNumber(String str) {
        return Pattern.matches("^[0-9]*$", str);
    }

    public static String byteArrayToString(byte[] array) {
        String s = "";
        for (byte b : array) {
            s = s + String.format("%02X", b) + " ";
        }
        s = s.trim();
        return s;
    }

    public static byte[] stringToByteArray(String str) {
        str = str.trim();
        String[] array = str.split(" ");
        byte[] b = new byte[array.length];
        int i = 0;
        try {
            for (String a : array) {
                byte high = (byte)(Character.digit(a.charAt(0), 16) & 0xFF);
                byte low = (byte)(Character.digit(a.charAt(1), 16) & 0xFF);
                b[i] = (byte)(high << 4 | low);
                ++i;
            }
        }
        catch (Exception e) {
            b = null;
        }
        return b;
    }
}

