/*
 * Decompiled with CFR 0.152.
 */
package com.simba.business;

import com.simba.business.OnTimeTickListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ServerTimeTickManager {
    private List<OnTimeTickListener> onServerTimeTickEvent;
    private int timeTickInterval = 1;
    private static ScheduledExecutorService service = null;
    private static ServerTimeTickManager instance;

    public static ServerTimeTickManager getInstance() {
        if (instance == null) {
            instance = new ServerTimeTickManager();
        }
        return instance;
    }

    public void addListener(OnTimeTickListener listener) {
        if (this.onServerTimeTickEvent != null) {
            this.onServerTimeTickEvent.add(listener);
        }
    }

    private void createTimer() {
        if (service == null) {
            service = Executors.newSingleThreadScheduledExecutor();
        }
    }

    private void startTimer(int mills) {
        if (mills < 1) {
            mills = 1;
        }
        if (service != null) {
            Runnable runnable = this::doTriggerTimeTickEvent;
            service.scheduleAtFixedRate(runnable, 10L, mills, TimeUnit.SECONDS);
        }
    }

    public void stopTimer() {
        if (service != null) {
            service.shutdown();
        }
    }

    public void disposeTimer() {
        if (service != null) {
            service.shutdown();
            service = null;
        }
    }

    private void doTriggerTimeTickEvent() {
        if (this.onServerTimeTickEvent != null) {
            for (OnTimeTickListener listener : this.onServerTimeTickEvent) {
                listener.OnServerTimeTickEvent();
            }
        }
    }

    public void init() {
        this.onServerTimeTickEvent = new ArrayList<OnTimeTickListener>();
        this.createTimer();
        this.startTimer(this.timeTickInterval);
    }

    public void shutDown() {
        this.onServerTimeTickEvent.clear();
        this.closeAllTimer();
    }

    private void closeAllTimer() {
        this.stopTimer();
        this.disposeTimer();
    }
}

